/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.zip;

import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipException;
import org.codehaus.plexus.archiver.zip.UnrecognizedExtraField;
import org.codehaus.plexus.archiver.zip.ZipExtraField;
import org.codehaus.plexus.archiver.zip.ZipShort;

public class ExtraFieldUtils {
    private static Hashtable implementations = new Hashtable();
    static /* synthetic */ Class class$org$codehaus$plexus$archiver$zip$AsiExtraField;

    static {
        ExtraFieldUtils.register(class$org$codehaus$plexus$archiver$zip$AsiExtraField != null ? class$org$codehaus$plexus$archiver$zip$AsiExtraField : (class$org$codehaus$plexus$archiver$zip$AsiExtraField = ExtraFieldUtils.class$("org.codehaus.plexus.archiver.zip.AsiExtraField")));
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public static ZipExtraField createExtraField(ZipShort headerId) throws InstantiationException, IllegalAccessException {
        Class c = (Class)implementations.get(headerId);
        if (c != null) {
            return (ZipExtraField)c.newInstance();
        }
        UnrecognizedExtraField u = new UnrecognizedExtraField();
        u.setHeaderId(headerId);
        return u;
    }

    public static byte[] mergeCentralDirectoryData(ZipExtraField[] data) {
        int sum = 4 * data.length;
        int i = 0;
        while (i < data.length) {
            sum += data[i].getCentralDirectoryLength().getValue();
            ++i;
        }
        byte[] result = new byte[sum];
        int start = 0;
        int i2 = 0;
        while (i2 < data.length) {
            System.arraycopy(data[i2].getHeaderId().getBytes(), 0, result, start, 2);
            System.arraycopy(data[i2].getCentralDirectoryLength().getBytes(), 0, result, start + 2, 2);
            byte[] local = data[i2].getCentralDirectoryData();
            System.arraycopy(local, 0, result, start + 4, local.length);
            start += local.length + 4;
            ++i2;
        }
        return result;
    }

    public static byte[] mergeLocalFileDataData(ZipExtraField[] data) {
        int sum = 4 * data.length;
        int i = 0;
        while (i < data.length) {
            sum += data[i].getLocalFileDataLength().getValue();
            ++i;
        }
        byte[] result = new byte[sum];
        int start = 0;
        int i2 = 0;
        while (i2 < data.length) {
            System.arraycopy(data[i2].getHeaderId().getBytes(), 0, result, start, 2);
            System.arraycopy(data[i2].getLocalFileDataLength().getBytes(), 0, result, start + 2, 2);
            byte[] local = data[i2].getLocalFileDataData();
            System.arraycopy(local, 0, result, start + 4, local.length);
            start += local.length + 4;
            ++i2;
        }
        return result;
    }

    public static ZipExtraField[] parse(byte[] data) throws ZipException {
        Vector<ZipExtraField> v = new Vector<ZipExtraField>();
        int start = 0;
        while (start <= data.length - 4) {
            ZipShort headerId = new ZipShort(data, start);
            int length = new ZipShort(data, start + 2).getValue();
            if (start + 4 + length > data.length) {
                throw new ZipException("data starting at " + start + " is in unknown format");
            }
            try {
                ZipExtraField ze = ExtraFieldUtils.createExtraField(headerId);
                ze.parseFromLocalFileData(data, start + 4, length);
                v.addElement(ze);
            }
            catch (InstantiationException ie) {
                throw new ZipException(ie.getMessage());
            }
            catch (IllegalAccessException iae) {
                throw new ZipException(iae.getMessage());
            }
            start += length + 4;
        }
        if (start != data.length) {
            throw new ZipException("data starting at " + start + " is in unknown format");
        }
        Object[] result = new ZipExtraField[v.size()];
        v.copyInto(result);
        return result;
    }

    public static void register(Class c) {
        try {
            ZipExtraField ze = (ZipExtraField)c.newInstance();
            implementations.put(ze.getHeaderId(), c);
        }
        catch (ClassCastException classCastException) {
            throw new RuntimeException(String.valueOf(String.valueOf(c)) + " doesn't implement ZipExtraField");
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(String.valueOf(String.valueOf(c)) + " is not a concrete class");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(String.valueOf(String.valueOf(c)) + "'s no-arg constructor is not public");
        }
    }
}

