/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.war;

import java.io.File;
import java.io.IOException;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.zip.ZipOutputStream;

public class WarArchiver
extends JarArchiver {
    private File deploymentDescriptor;
    private boolean descriptorAdded;

    public WarArchiver() {
        this.archiveType = "war";
    }

    public void addClass(File fileName) throws ArchiverException {
        this.addDirectory(fileName.getParentFile(), "WEB-INF/classes/", new String[]{fileName.getName()}, null);
    }

    public void addClasses(File directoryName, String[] includes, String[] excludes) throws ArchiverException {
        this.addDirectory(directoryName, "WEB-INF/classes/", includes, excludes);
    }

    public void addLib(File fileName) throws ArchiverException {
        this.addDirectory(fileName.getParentFile(), "WEB-INF/lib/", new String[]{fileName.getName()}, null);
    }

    public void addLibs(File directoryName, String[] includes, String[] excludes) throws ArchiverException {
        this.addDirectory(directoryName, "WEB-INF/lib/", includes, excludes);
    }

    public void addWebinf(File directoryName, String[] includes, String[] excludes) throws ArchiverException {
        this.addDirectory(directoryName, "WEB-INF/", includes, excludes);
    }

    protected void cleanUp() {
        this.descriptorAdded = false;
        super.cleanUp();
    }

    protected void initZipOutputStream(ZipOutputStream zOut) throws IOException, ArchiverException {
        if (this.deploymentDescriptor == null && !this.isInUpdateMode()) {
            throw new ArchiverException("webxml attribute is required");
        }
        super.initZipOutputStream(zOut);
    }

    public void setWebxml(File descr) throws ArchiverException {
        this.deploymentDescriptor = descr;
        if (!this.deploymentDescriptor.exists()) {
            throw new ArchiverException("Deployment descriptor: " + this.deploymentDescriptor + " does not exist.");
        }
        this.addFile(descr, "WEB-INF/web.xml");
    }

    protected void zipFile(File file, ZipOutputStream zOut, String vPath, int mode) throws IOException, ArchiverException {
        if (vPath.equalsIgnoreCase("WEB-INF/web.xml")) {
            if (this.deploymentDescriptor == null || !this.deploymentDescriptor.getAbsolutePath().equals(file.getAbsolutePath()) || this.descriptorAdded) {
                this.getLogger().warn("Warning: selected " + this.archiveType + " files include a WEB-INF/web.xml which will be ignored " + "(please use webxml attribute to " + this.archiveType + " task)");
            } else {
                super.zipFile(file, zOut, vPath, mode);
                this.descriptorAdded = true;
            }
        } else {
            super.zipFile(file, zOut, vPath, mode);
        }
    }
}

