/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.logging.AbstractLogEnabled;

public abstract class Compressor
extends AbstractLogEnabled {
    private File destFile;
    private File sourceFile;

    protected abstract void compress() throws ArchiverException;

    protected void compressFile(File file, OutputStream zOut) throws IOException {
        FileInputStream fIn = new FileInputStream(file);
        try {
            this.compressFile(fIn, zOut);
        }
        finally {
            Object var5_4 = null;
            fIn.close();
        }
    }

    private void compressFile(InputStream in, OutputStream zOut) throws IOException {
        byte[] buffer = new byte[8192];
        int count = 0;
        do {
            zOut.write(buffer, 0, count);
        } while ((count = in.read(buffer, 0, buffer.length)) != -1);
    }

    public void execute() throws ArchiverException {
        this.validate();
        if (this.sourceFile.exists() && this.destFile.lastModified() < this.sourceFile.lastModified()) {
            this.compress();
        }
    }

    public File getDestFile() {
        return this.destFile;
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public void setDestFile(File compressFile) {
        this.destFile = compressFile;
    }

    public void setSourceFile(File srcFile) {
        this.sourceFile = srcFile;
    }

    private void validate() throws ArchiverException {
        if (this.destFile == null) {
            throw new ArchiverException("Destination file attribute is required");
        }
        if (this.destFile.isDirectory()) {
            throw new ArchiverException("Destination file attribute must not represent a directory!");
        }
        if (this.sourceFile == null) {
            throw new ArchiverException("Source file attribute is required");
        }
        if (this.sourceFile.isDirectory()) {
            throw new ArchiverException("Source file attribute must not represent a directory!");
        }
    }
}

