/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.jar;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.archiver.util.EnumeratedAttribute;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.archiver.zip.ZipEntry;
import org.codehaus.plexus.archiver.zip.ZipFile;
import org.codehaus.plexus.archiver.zip.ZipOutputStream;

public class JarArchiver
extends ZipArchiver {
    private static final String INDEX_NAME = "META-INF/INDEX.LIST";
    private static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    private Manifest configuredManifest;
    private Manifest savedConfiguredManifest;
    private Manifest filesetManifest;
    private Manifest originalManifest;
    private FilesetManifestConfig filesetManifestConfig;
    private boolean mergeManifestsMain = true;
    private Manifest manifest;
    private String manifestEncoding;
    private File manifestFile;
    private boolean index = false;
    private boolean createEmpty = false;
    private Vector rootEntries;
    private ArrayList indexJars;

    public JarArchiver() {
        this.archiveType = "jar";
        this.setEncoding("UTF8");
        this.rootEntries = new Vector();
    }

    public void addConfiguredIndexJars(File indexJar) {
        if (this.indexJars == null) {
            this.indexJars = new ArrayList();
        }
        this.indexJars.add(indexJar.getAbsolutePath());
    }

    public void addConfiguredManifest(Manifest newManifest) throws ManifestException {
        if (this.configuredManifest == null) {
            this.configuredManifest = newManifest;
        } else {
            this.configuredManifest.merge(newManifest);
        }
        this.savedConfiguredManifest = this.configuredManifest;
    }

    protected void cleanUp() {
        super.cleanUp();
        if (!this.doubleFilePass || this.doubleFilePass && !this.skipWriting) {
            this.manifest = null;
            this.configuredManifest = this.savedConfiguredManifest;
            this.filesetManifest = null;
            this.originalManifest = null;
        }
        this.rootEntries.removeAllElements();
    }

    protected boolean createEmptyZip(File zipFile) throws ArchiverException {
        if (!this.createEmpty) {
            return true;
        }
        ZipOutputStream zOut = null;
        try {
            try {
                this.getLogger().debug("Building MANIFEST-only jar: " + this.getDestFile().getAbsolutePath());
                zOut = new ZipOutputStream(new FileOutputStream(this.getDestFile()));
                zOut.setEncoding(this.getEncoding());
                if (this.isCompress()) {
                    zOut.setMethod(8);
                } else {
                    zOut.setMethod(0);
                }
                this.initZipOutputStream(zOut);
                this.finalizeZipOutputStream(zOut);
            }
            catch (IOException ioe) {
                throw new ArchiverException("Could not create almost empty JAR archive (" + ioe.getMessage() + ")", ioe);
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                if (zOut != null) {
                    zOut.close();
                }
            }
            catch (IOException iOException) {}
            this.createEmpty = false;
            throw throwable;
        }
        try {
            if (zOut != null) {
                zOut.close();
            }
        }
        catch (IOException iOException) {}
        this.createEmpty = false;
        return true;
    }

    private void createIndexList(ZipOutputStream zOut) throws IOException, ArchiverException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)baos, "UTF8"));
        writer.println("JarIndex-Version: 1.0");
        writer.println();
        writer.println(this.getDestFile().getName());
        this.writeIndexLikeList(new ArrayList(this.addedDirs.keySet()), this.rootEntries, writer);
        writer.println();
        if (this.indexJars != null) {
            Manifest mf = this.createManifest();
            Manifest.Attribute classpath = mf.getMainSection().getAttribute("Class-Path");
            String[] cpEntries = null;
            if (classpath != null) {
                StringTokenizer tok = new StringTokenizer(classpath.getValue(), " ");
                cpEntries = new String[tok.countTokens()];
                int c = 0;
                while (tok.hasMoreTokens()) {
                    cpEntries[c++] = tok.nextToken();
                }
            }
            String[] indexJarEntries = (String[])this.indexJars.toArray();
            int i = 0;
            while (i < indexJarEntries.length) {
                String name = JarArchiver.findJarName(indexJarEntries[i], cpEntries);
                if (name != null) {
                    ArrayList dirs = new ArrayList();
                    ArrayList files = new ArrayList();
                    JarArchiver.grabFilesAndDirs(indexJarEntries[i], dirs, files);
                    if (dirs.size() + files.size() > 0) {
                        writer.println(name);
                        this.writeIndexLikeList(dirs, files, writer);
                        writer.println();
                    }
                }
                ++i;
            }
        }
        writer.flush();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        super.zipFile(bais, zOut, INDEX_NAME, System.currentTimeMillis(), null, 33188);
    }

    private Manifest createManifest() throws ArchiverException {
        try {
            Manifest finalManifest = Manifest.getDefaultManifest();
            if (this.manifest == null && this.manifestFile != null) {
                this.manifest = this.getManifest(this.manifestFile);
            }
            if (this.isInUpdateMode()) {
                finalManifest.merge(this.originalManifest);
            }
            finalManifest.merge(this.filesetManifest);
            finalManifest.merge(this.configuredManifest);
            finalManifest.merge(this.manifest, this.mergeManifestsMain ^ true);
            return finalManifest;
        }
        catch (ManifestException e) {
            this.getLogger().error("Manifest is invalid: " + e.getMessage());
            throw new ArchiverException("Invalid Manifest", e);
        }
    }

    private void filesetManifest(File file, InputStream is) throws IOException, ArchiverException {
        if (this.manifestFile != null && this.manifestFile.equals(file)) {
            this.getLogger().debug("Found manifest " + file);
            try {
                if (is != null) {
                    InputStreamReader isr = this.manifestEncoding == null ? new InputStreamReader(is) : new InputStreamReader(is, this.manifestEncoding);
                    this.manifest = this.getManifest(isr);
                }
                this.manifest = this.getManifest(file);
            }
            catch (UnsupportedEncodingException e) {
                throw new ArchiverException("Unsupported encoding while reading manifest: " + e.getMessage(), e);
            }
        } else if (this.filesetManifestConfig != null && !this.filesetManifestConfig.getValue().equals("skip")) {
            this.getLogger().debug("Found manifest to merge in file " + file);
            try {
                Manifest newManifest = null;
                if (is != null) {
                    InputStreamReader isr = this.manifestEncoding == null ? new InputStreamReader(is) : new InputStreamReader(is, this.manifestEncoding);
                    newManifest = this.getManifest(isr);
                } else {
                    newManifest = this.getManifest(file);
                }
                if (this.filesetManifest == null) {
                    this.filesetManifest = newManifest;
                } else {
                    this.filesetManifest.merge(newManifest);
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new ArchiverException("Unsupported encoding while reading manifest: " + e.getMessage(), e);
            }
            catch (ManifestException e) {
                this.getLogger().error("Manifest in file " + file + " is invalid: " + e.getMessage());
                throw new ArchiverException("Invalid Manifest", e);
            }
        }
    }

    protected void finalizeZipOutputStream(ZipOutputStream zOut) throws IOException, ArchiverException {
        if (this.index) {
            this.createIndexList(zOut);
        }
    }

    protected static final String findJarName(String fileName, String[] classpath) {
        if (classpath == null) {
            return new File(fileName).getName();
        }
        fileName = fileName.replace(File.separatorChar, '/');
        TreeMap<String, String> matches = new TreeMap<String, String>(new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 instanceof String && o2 instanceof String) {
                    return ((String)o2).length() - ((String)o1).length();
                }
                return 0;
            }
        });
        int i = 0;
        while (i < classpath.length) {
            if (fileName.endsWith(classpath[i])) {
                matches.put(classpath[i], classpath[i]);
            } else {
                int slash = classpath[i].indexOf("/");
                String candidate = classpath[i];
                while (slash > -1) {
                    if (fileName.endsWith(candidate = candidate.substring(slash + 1))) {
                        matches.put(candidate, classpath[i]);
                        break;
                    }
                    slash = candidate.indexOf("/");
                }
            }
            ++i;
        }
        return matches.size() == 0 ? null : (String)matches.get(matches.firstKey());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Manifest getManifest(File manifestFile) throws ArchiverException {
        Manifest newManifest = null;
        FileInputStream fis = null;
        InputStreamReader isr = null;
        try {
            try {
                fis = new FileInputStream(manifestFile);
                isr = this.manifestEncoding == null ? new InputStreamReader(fis) : new InputStreamReader((InputStream)fis, this.manifestEncoding);
                newManifest = this.getManifest(isr);
            }
            catch (UnsupportedEncodingException e) {
                throw new ArchiverException("Unsupported encoding while reading manifest: " + e.getMessage(), e);
            }
            catch (IOException e) {
                throw new ArchiverException("Unable to read manifest file: " + manifestFile + " (" + e.getMessage() + ")", e);
            }
            Object var6_7 = null;
            if (isr == null) return newManifest;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (isr == null) throw throwable;
            try {
                isr.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            isr.close();
            return newManifest;
        }
        catch (IOException iOException) {}
        return newManifest;
    }

    private Manifest getManifest(Reader r) throws ArchiverException {
        Manifest newManifest = null;
        try {
            newManifest = new Manifest(r);
        }
        catch (ManifestException e) {
            this.getLogger().error("Manifest is invalid: " + e.getMessage());
            throw new ArchiverException("Invalid Manifest: " + this.manifestFile, e);
        }
        catch (IOException e) {
            throw new ArchiverException("Unable to read manifest file (" + e.getMessage() + ")", e);
        }
        return newManifest;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Manifest getManifestFromJar(File jarFile) throws IOException, ArchiverException {
        Manifest manifest;
        java.util.zip.ZipFile zf;
        block7: {
            Manifest manifest2;
            zf = null;
            try {
                java.util.zip.ZipEntry ze;
                zf = new java.util.zip.ZipFile(jarFile);
                Enumeration<? extends java.util.zip.ZipEntry> e = zf.entries();
                do {
                    if (e.hasMoreElements()) continue;
                    manifest = null;
                    break block7;
                } while (!(ze = e.nextElement()).getName().equalsIgnoreCase(MANIFEST_NAME));
                InputStreamReader isr = new InputStreamReader(zf.getInputStream(ze), "UTF-8");
                manifest2 = this.getManifest(isr);
                Object var5_8 = null;
                if (zf == null) return manifest2;
            }
            catch (Throwable throwable) {
                Object var5_10 = null;
                if (zf == null) throw throwable;
                try {
                    zf.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw throwable;
                }
            }
            try {}
            catch (IOException iOException) {}
            zf.close();
            return manifest2;
        }
        Object var5_9 = null;
        if (zf == null) return manifest;
        try {}
        catch (IOException iOException) {}
        zf.close();
        return manifest;
    }

    protected static final void grabFilesAndDirs(String file, List dirs, List files) throws IOException {
        ZipFile zf = null;
        try {
            zf = new ZipFile(file, "utf-8");
            Enumeration entries = zf.getEntries();
            HashSet<String> dirSet = new HashSet<String>();
            while (entries.hasMoreElements()) {
                ZipEntry ze = (ZipEntry)entries.nextElement();
                String name = ze.getName();
                if (name.startsWith("META-INF/")) continue;
                if (ze.isDirectory()) {
                    dirSet.add(name);
                    continue;
                }
                if (name.indexOf("/") == -1) {
                    files.add(name);
                    continue;
                }
                dirSet.add(name.substring(0, name.lastIndexOf("/") + 1));
            }
            dirs.addAll(dirSet);
        }
        finally {
            Object var5_8 = null;
            if (zf != null) {
                zf.close();
            }
        }
    }

    protected void initZipOutputStream(ZipOutputStream zOut) throws IOException, ArchiverException {
        if (!this.skipWriting) {
            Manifest jarManifest = this.createManifest();
            this.writeManifest(zOut, jarManifest);
        }
    }

    public void reset() {
        super.reset();
        this.configuredManifest = null;
        this.filesetManifestConfig = null;
        this.mergeManifestsMain = false;
        this.manifestFile = null;
        this.index = false;
    }

    public void setFilesetmanifest(FilesetManifestConfig config) {
        this.filesetManifestConfig = config;
        this.mergeManifestsMain = "merge".equals(config.getValue());
        if (this.filesetManifestConfig != null && !this.filesetManifestConfig.getValue().equals("skip")) {
            this.doubleFilePass = true;
        }
    }

    public void setIndex(boolean flag) {
        this.index = flag;
    }

    public void setManifest(File manifestFile) throws ArchiverException {
        if (!manifestFile.exists()) {
            throw new ArchiverException("Manifest file: " + manifestFile + " does not exist.");
        }
        this.manifestFile = manifestFile;
    }

    public void setManifestEncoding(String manifestEncoding) {
        this.manifestEncoding = manifestEncoding;
    }

    protected final void writeIndexLikeList(List dirs, List files, PrintWriter writer) throws IOException {
        Collections.sort(dirs);
        Collections.sort(files);
        Iterator iter = dirs.iterator();
        while (iter.hasNext()) {
            String dir = (String)iter.next();
            if ((dir = dir.replace('\\', '/')).startsWith("./")) {
                dir = dir.substring(2);
            }
            while (dir.startsWith("/")) {
                dir = dir.substring(1);
            }
            int pos = dir.lastIndexOf(47);
            if (pos != -1) {
                dir = dir.substring(0, pos);
            }
            if (dir.startsWith("META-INF")) continue;
            writer.println(dir);
        }
        iter = files.iterator();
        while (iter.hasNext()) {
            writer.println(iter.next());
        }
    }

    private void writeManifest(ZipOutputStream zOut, Manifest manifest) throws IOException, ArchiverException {
        Enumeration e = manifest.getWarnings();
        while (e.hasMoreElements()) {
            this.getLogger().warn("Manifest warning: " + (String)e.nextElement());
        }
        this.zipDir(null, zOut, "META-INF/", 16877);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, "UTF-8");
        PrintWriter writer = new PrintWriter(osw);
        manifest.write(writer);
        writer.flush();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        super.zipFile(bais, zOut, MANIFEST_NAME, System.currentTimeMillis(), null, 33188);
        super.initZipOutputStream(zOut);
    }

    protected void zipFile(InputStream is, ZipOutputStream zOut, String vPath, long lastModified, File fromArchive, int mode) throws IOException, ArchiverException {
        if (MANIFEST_NAME.equalsIgnoreCase(vPath)) {
            if (!this.doubleFilePass || this.doubleFilePass && this.skipWriting) {
                this.filesetManifest(fromArchive, is);
            }
        } else if (INDEX_NAME.equalsIgnoreCase(vPath) && this.index) {
            this.getLogger().warn("Warning: selected " + this.archiveType + " files include a META-INF/INDEX.LIST which will" + " be replaced by a newly generated one.");
        } else {
            if (this.index && vPath.indexOf("/") == -1) {
                this.rootEntries.addElement(vPath);
            }
            super.zipFile(is, zOut, vPath, lastModified, fromArchive, mode);
        }
    }

    public static class FilesetManifestConfig
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"skip", "merge", "mergewithoutmain"};
        }
    }
}

