/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver;

import java.io.File;
import java.io.IOException;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.logging.AbstractLogEnabled;

public abstract class AbstractUnArchiver
extends AbstractLogEnabled
implements UnArchiver {
    private File destDirectory;
    private File destFile;
    private File sourceFile;
    private boolean overwrite = true;

    protected abstract void execute() throws ArchiverException, IOException;

    public void extract() throws ArchiverException, IOException {
        this.validate();
        this.execute();
    }

    public File getDestDirectory() {
        return this.destDirectory;
    }

    public File getDestFile() {
        return this.destFile;
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setDestDirectory(File destDirectory) {
        this.destDirectory = destDirectory;
    }

    public void setDestFile(File destFile) {
        this.destFile = destFile;
    }

    public void setOverwrite(boolean b) {
        this.overwrite = b;
    }

    public void setSourceFile(File sourceFile) {
        this.sourceFile = sourceFile;
    }

    protected void validate() throws ArchiverException {
        if (this.sourceFile == null) {
            throw new ArchiverException("The source file isn't define.");
        }
        if (this.sourceFile.isDirectory()) {
            throw new ArchiverException("The source must not be a directory.");
        }
        if (!this.sourceFile.exists()) {
            throw new ArchiverException("The source doesn't exists.");
        }
        if (this.destDirectory == null && this.destFile == null) {
            throw new ArchiverException("The destination isn't define.");
        }
        if (this.destDirectory != null && this.destFile != null) {
            throw new ArchiverException("You must choose between a destination directory and a destination file.");
        }
        if (this.destDirectory != null && !this.destDirectory.isDirectory()) {
            this.destFile = this.destDirectory;
            this.destDirectory = null;
        }
        if (this.destFile != null && this.destFile.isDirectory()) {
            this.destDirectory = this.destFile;
            this.destFile = null;
        }
    }
}

