/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.application.supervisor;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.plexus.application.supervisor.SupervisedDirectory;
import org.codehaus.plexus.application.supervisor.Supervisor;
import org.codehaus.plexus.application.supervisor.SupervisorException;
import org.codehaus.plexus.application.supervisor.SupervisorListener;

public class DefaultSupervisor
implements Supervisor {
    private List directories = new ArrayList();

    public void addDirectory(File directory, SupervisorListener listener) throws SupervisorException {
        if (!directory.isDirectory()) {
            throw new SupervisorException("The specified directory doesn't exists or isn't a directory: '" + directory.getAbsolutePath() + "'.");
        }
        this.directories.add(new SupervisedDirectory(directory, listener));
    }

    public void scan() throws SupervisorException {
        Iterator it = this.directories.iterator();
        while (it.hasNext()) {
            SupervisedDirectory directory = (SupervisedDirectory)it.next();
            File dir = directory.getDirectory();
            SupervisorListener listener = directory.getListener();
            this.scanDirectory(dir, listener);
        }
    }

    private void scanDirectory(File dir, SupervisorListener listener) {
        File[] files = dir.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isFile() && file.getName().endsWith(".jar");
            }
        });
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            listener.onJarDiscovered(file);
        }
    }
}

