/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.application;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import org.codehaus.classworlds.ClassWorld;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.application.ApplicationServer;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.LoggerManager;

public class PlexusApplicationHost
implements Runnable {
    private DefaultPlexusContainer container;
    private boolean shouldStop;
    private boolean isStopped;
    private static Object waitObj = new Object();
    private ApplicationServer applicationServer;

    public PlexusContainer getContainer() {
        return this.container;
    }

    public ApplicationServer getApplicationServer() {
        return this.applicationServer;
    }

    public void start(ClassWorld classWorld, String configurationResource) throws Exception {
        this.container = new DefaultPlexusContainer();
        this.container.setClassWorld(classWorld);
        this.container.setConfigurationResource((Reader)new FileReader(configurationResource));
        this.container.addContextValue((Object)"plexus.home", (Object)System.getProperty("plexus.home"));
        this.container.addContextValue((Object)"plexus.work", (Object)(System.getProperty("plexus.home") + "/work"));
        this.container.addContextValue((Object)"plexus.logs", (Object)(System.getProperty("plexus.home") + "/logs"));
        File plexusLogs = new File(System.getProperty("plexus.home") + "/logs");
        if (!plexusLogs.exists()) {
            plexusLogs.mkdirs();
        }
        this.container.initialize();
        this.container.start();
        LoggerManager loggerManager = (LoggerManager)this.container.lookup(LoggerManager.ROLE);
        loggerManager.setThreshold(0);
        final Logger logger = loggerManager.getLoggerForComponent(this.getClass().getName());
        this.applicationServer = (ApplicationServer)this.container.lookup(ApplicationServer.ROLE);
        logger.info("The application server has started.");
        Thread thread = new Thread(this);
        thread.setDaemon(false);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            public void run() {
                try {
                    logger.info("Shutting down the application container.");
                    PlexusApplicationHost.this.shutdown();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }));
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        PlexusApplicationHost plexusApplicationHost = this;
        synchronized (plexusApplicationHost) {
            while (!this.shouldStop) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        plexusApplicationHost = this;
        synchronized (plexusApplicationHost) {
            this.isStopped = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws Exception {
        PlexusApplicationHost plexusApplicationHost = this;
        synchronized (plexusApplicationHost) {
            this.shouldStop = true;
            this.container.release((Object)this.applicationServer);
            this.container.dispose();
            this.notifyAll();
        }
        plexusApplicationHost = this;
        synchronized (plexusApplicationHost) {
            while (!this.isStopped) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            Object object = waitObj;
            synchronized (object) {
                waitObj.notifyAll();
            }
        }
    }

    private boolean isStopped() {
        return this.isStopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args, ClassWorld classWorld) {
        if (args.length != 1) {
            System.err.println("usage: plexus <plexus.xml>");
            System.exit(1);
        }
        try {
            PlexusApplicationHost host = new PlexusApplicationHost();
            host.start(classWorld, args[0]);
            while (!host.isStopped()) {
                try {
                    Object object = waitObj;
                    synchronized (object) {
                        waitObj.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(2);
        }
    }
}

