/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.application;

import java.io.File;
import org.codehaus.plexus.application.ApplicationServer;
import org.codehaus.plexus.application.ApplicationServerException;
import org.codehaus.plexus.application.deploy.ApplicationDeployer;
import org.codehaus.plexus.application.profile.ApplicationRuntimeProfile;
import org.codehaus.plexus.application.service.ServiceDiscoverer;
import org.codehaus.plexus.application.supervisor.Supervisor;
import org.codehaus.plexus.application.supervisor.SupervisorException;
import org.codehaus.plexus.application.supervisor.SupervisorListener;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Startable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.StartingException;

public class DefaultApplicationServer
extends AbstractLogEnabled
implements ApplicationServer,
Startable {
    private ApplicationDeployer applicationDeployer;
    private ServiceDiscoverer serviceDiscoverer;
    private Supervisor supervisor;

    public ApplicationRuntimeProfile getApplicationRuntimeProfile(String applicationId) throws ApplicationServerException {
        return this.applicationDeployer.getApplicationRuntimeProfile(applicationId);
    }

    public void start() throws StartingException {
        File home = new File(System.getProperty("plexus.home"));
        try {
            this.supervisor.addDirectory(new File(home, "services"), new SupervisorListener(){

                public void onJarDiscovered(File jar) {
                    String name = jar.getName();
                    try {
                        DefaultApplicationServer.this.serviceDiscoverer.deploy(name.substring(0, name.length() - 4), jar.getAbsolutePath());
                    }
                    catch (Exception e) {
                        System.err.println("Error while deploying service '" + name + "'.");
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (SupervisorException e) {
            throw new StartingException("Error deploying services in the app server.", (Throwable)e);
        }
        try {
            this.supervisor.addDirectory(new File(home, "apps"), new SupervisorListener(){

                public void onJarDiscovered(File jar) {
                    String name = jar.getName();
                    try {
                        DefaultApplicationServer.this.applicationDeployer.deploy(name.substring(0, name.length() - 4), jar.toURL().toExternalForm());
                    }
                    catch (Exception e) {
                        System.err.println("Error while deploying application '" + name + "'.");
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (SupervisorException e) {
            throw new StartingException("Error deploying applications in the app server.", (Throwable)e);
        }
        this.getLogger().info("The application server has been initialized.");
        try {
            this.supervisor.scan();
        }
        catch (SupervisorException e) {
            throw new StartingException("Error while scanning for new services and applications.", (Throwable)e);
        }
    }

    public void stop() {
    }
}

