/*
 * Decompiled with CFR 0.152.
 */
package pl.wrzasq.lambda.macro.pipeline.project.template;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import pl.wrzasq.commons.aws.cloudformation.macro.TemplateUtils;

public class PipelineProjectResource {
    public static final String RESOURCE_TYPE = "WrzasqPl::Pipeline::Project";
    private static final Number DEFAULT_LOGS_RETENTION_DAYS = 14;
    private static final String PROPERTY_LOG_GROUP_NAME = "LogGroupName";
    private static final String PROPERTY_LOGS_RETENTION_IN_DAYS = "LogsRetentionInDays";
    private static final String PROPERTY_ARTIFACTS = "Artifacts";
    private static final String PROPERTY_SOURCE = "Source";
    private static final String PROPERTY_ENVIRONMENT = "Environment";
    private static final String PROPERTY_KEY_TYPE = "Type";
    private static final String PROPERTY_KEY_COMPUTE_TYPE = "ComputeType";
    private static final String PROPERTY_KEY_ENVIRONMENTVARIABLES = "EnvironmentVariables";
    private String logicalId;
    private String condition;

    public Map<String, Object> buildDefinitions(Map<String, Object> properties) {
        HashMap<String, Object> resources = new HashMap<String, Object>();
        this.createLogGroup(resources, properties);
        this.createCodeBuildProject(resources, properties);
        return resources;
    }

    private void createLogGroup(Map<String, Object> resources, Map<String, Object> properties) {
        HashMap<String, Object> resourceProperties = new HashMap<String, Object>();
        resourceProperties.put(PROPERTY_LOG_GROUP_NAME, TemplateUtils.sub((Object)String.format("/aws/codebuild/${%s}", this.logicalId)));
        TemplateUtils.popProperty(properties, (String)PROPERTY_LOGS_RETENTION_IN_DAYS, value -> resourceProperties.put("RetentionInDays", value), (Object)DEFAULT_LOGS_RETENTION_DAYS);
        this.generateResource(resources, "LogGroup", "Logs::LogGroup", resourceProperties);
    }

    private void createCodeBuildProject(Map<String, Object> resources, Map<String, Object> properties) {
        properties.computeIfAbsent(PROPERTY_ARTIFACTS, key -> PipelineProjectResource.generateArtifactsDelegation());
        properties.computeIfAbsent(PROPERTY_SOURCE, key -> PipelineProjectResource.generateArtifactsDelegation());
        Map environment = TemplateUtils.asMap((Object)properties.computeIfAbsent(PROPERTY_ENVIRONMENT, key -> new HashMap()));
        properties.put(PROPERTY_ENVIRONMENT, environment);
        environment.putIfAbsent(PROPERTY_KEY_TYPE, "LINUX_CONTAINER");
        environment.putIfAbsent(PROPERTY_KEY_COMPUTE_TYPE, "BUILD_GENERAL1_SMALL");
        TemplateUtils.popProperty(properties, (String)"Variables", value -> environment.put(PROPERTY_KEY_ENVIRONMENTVARIABLES, PipelineProjectResource.addMapToEntries(environment.computeIfAbsent(PROPERTY_KEY_ENVIRONMENTVARIABLES, key -> new ArrayList()), value)), null);
        this.generateResource(resources, "", "CodeBuild::Project", properties);
    }

    public String getLogGroupLogicalId() {
        return String.format("%sLogGroup", this.logicalId);
    }

    private void generateResource(Map<String, Object> resources, String suffix, String type, Map<String, Object> properties) {
        resources.put(String.format("%s%s", this.logicalId, suffix), TemplateUtils.generateResource((String)type, properties, (String)this.condition));
    }

    private static Map<String, Object> generateArtifactsDelegation() {
        HashMap<String, Object> setup = new HashMap<String, Object>();
        setup.put(PROPERTY_KEY_TYPE, "CODEPIPELINE");
        return setup;
    }

    private static List<Object> addMapToEntries(Object container, Object map) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (container instanceof List) {
            list.addAll((List)container);
        }
        TemplateUtils.asMap((Object)map).forEach((key, value) -> list.add(PipelineProjectResource.buildEnvironmentVariable(key, value)));
        return list;
    }

    private static Map<String, Object> buildEnvironmentVariable(String key, Object value) {
        HashMap<String, Object> container = new HashMap<String, Object>();
        container.put("Name", key);
        container.put("Value", value);
        return container;
    }

    @Generated
    public PipelineProjectResource(String logicalId, String condition) {
        this.logicalId = logicalId;
        this.condition = condition;
    }
}

