/*
 * Decompiled with CFR 0.152.
 */
package pl.wrzasq.lambda.macro.pipeline.project.template;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.wrzasq.commons.aws.cloudformation.macro.ResourcesDefinition;
import pl.wrzasq.commons.aws.cloudformation.macro.TemplateDefinition;
import pl.wrzasq.commons.aws.cloudformation.macro.TemplateUtils;
import pl.wrzasq.commons.json.ObjectMapperFactory;
import pl.wrzasq.lambda.macro.pipeline.project.template.PipelineProjectResource;

public class ProcessedTemplate
implements TemplateDefinition {
    private static ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper();
    private static Logger logger = LoggerFactory.getLogger(ProcessedTemplate.class);
    private Map<String, PipelineProjectResource> resources = new HashMap<String, PipelineProjectResource>();
    private Map<String, Object> template;

    public ProcessedTemplate(Map<String, Object> input) {
        this.template = this.replaceReferences(this.createResources(input));
    }

    private Map<String, Object> createResources(Map<String, Object> input) {
        HashMap<String, Object> output = new HashMap<String, Object>(input);
        Map<String, Object> section = TemplateUtils.asMap(input.get("Resources"));
        HashMap<String, Object> resources = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : section.entrySet()) {
            ResourcesDefinition definition = objectMapper.convertValue(entry.getValue(), ResourcesDefinition.class);
            if (definition.getType().equals("WrzasqPl::Pipeline::Project")) {
                resources.putAll(this.createResource(entry.getKey(), definition.getProperties(), definition.getCondition()));
                continue;
            }
            resources.put(entry.getKey(), section.get(entry.getKey()));
        }
        output.put("Resources", resources);
        return output;
    }

    private Map<String, Object> createResource(String key, Map<String, Object> properties2, String condition) {
        logger.info("Creating resources for {}.", (Object)key);
        PipelineProjectResource resource = new PipelineProjectResource(key, condition);
        this.resources.put(key, resource);
        return resource.buildDefinitions(properties2);
    }

    private Map<String, Object> replaceReferences(Map<String, Object> input) {
        HashMap<String, Object> output = new HashMap<String, Object>(input);
        Map<String, Object> section = TemplateUtils.asMap(input.get("Resources"));
        section = this.replaceDependencies(section);
        output.put("Resources", this.replaceDependencies(section));
        return output;
    }

    private Map<String, Object> replaceDependencies(Map<String, Object> resources) {
        HashMap<String, Object> output = new HashMap<String, Object>();
        for (Map.Entry<String, Object> resource : resources.entrySet()) {
            String logicalId = resource.getKey();
            Map<String, Object> config = TemplateUtils.asMap(resource.getValue());
            if (config.containsKey("DependsOn")) {
                Object dependsOn = config.get("DependsOn");
                config.put("DependsOn", this.replaceDependenciesIn(dependsOn));
            }
            output.put(logicalId, config);
        }
        return output;
    }

    private Object replaceDependenciesIn(Object dependsOn) {
        if (dependsOn instanceof List) {
            return ((List)dependsOn).stream().map(Object::toString).map(this::resolveDependency).collect(Collectors.toList());
        }
        return this.resolveDependency(dependsOn.toString());
    }

    private String resolveDependency(String dependency) {
        return this.resources.containsKey(dependency) ? this.resources.get(dependency).getLogGroupLogicalId() : dependency;
    }

    @Override
    @Generated
    public Map<String, Object> getTemplate() {
        return this.template;
    }
}

