/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray;

import com.amazonaws.xray.AWSXRayRecorderBuilder;
import com.amazonaws.xray.ThreadLocalStorage;
import com.amazonaws.xray.contexts.LambdaSegmentContextResolver;
import com.amazonaws.xray.contexts.SegmentContext;
import com.amazonaws.xray.contexts.SegmentContextResolverChain;
import com.amazonaws.xray.contexts.ThreadLocalSegmentContextResolver;
import com.amazonaws.xray.emitters.DefaultEmitter;
import com.amazonaws.xray.emitters.Emitter;
import com.amazonaws.xray.entities.AWSLogReference;
import com.amazonaws.xray.entities.DummySegment;
import com.amazonaws.xray.entities.Entity;
import com.amazonaws.xray.entities.FacadeSegment;
import com.amazonaws.xray.entities.Segment;
import com.amazonaws.xray.entities.SegmentImpl;
import com.amazonaws.xray.entities.Subsegment;
import com.amazonaws.xray.entities.TraceID;
import com.amazonaws.xray.exceptions.SegmentNotFoundException;
import com.amazonaws.xray.exceptions.SubsegmentNotFoundException;
import com.amazonaws.xray.listeners.SegmentListener;
import com.amazonaws.xray.strategy.ContextMissingStrategy;
import com.amazonaws.xray.strategy.DefaultContextMissingStrategy;
import com.amazonaws.xray.strategy.DefaultPrioritizationStrategy;
import com.amazonaws.xray.strategy.DefaultStreamingStrategy;
import com.amazonaws.xray.strategy.DefaultThrowableSerializationStrategy;
import com.amazonaws.xray.strategy.PrioritizationStrategy;
import com.amazonaws.xray.strategy.StreamingStrategy;
import com.amazonaws.xray.strategy.ThrowableSerializationStrategy;
import com.amazonaws.xray.strategy.sampling.DefaultSamplingStrategy;
import com.amazonaws.xray.strategy.sampling.SamplingStrategy;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AWSXRayRecorder {
    private static final Log logger;
    private static final String PROPERTIES_LOCATION = "/com/amazonaws/xray/sdk.properties";
    private static final String SDK_VERSION_KEY = "awsxrayrecordersdk.version";
    private static final String DEFAULT_SDK_VERSION = "unknown";
    private static final String SDK = "X-Ray for Java";
    private static final String CW_LOGS_KEY = "cloudwatch_logs";
    private static Map<String, Object> SDK_VERSION_INFORMATION;
    private static Map<String, Object> RUNTIME_INFORMATION;
    private SamplingStrategy samplingStrategy = new DefaultSamplingStrategy();
    private StreamingStrategy streamingStrategy = new DefaultStreamingStrategy();
    private PrioritizationStrategy prioritizationStrategy = new DefaultPrioritizationStrategy();
    private ThrowableSerializationStrategy throwableSerializationStrategy = new DefaultThrowableSerializationStrategy();
    private ContextMissingStrategy contextMissingStrategy = new DefaultContextMissingStrategy();
    private SegmentContextResolverChain segmentContextResolverChain;
    private Emitter emitter;
    private ArrayList<SegmentListener> segmentListeners;
    private Map<String, Object> awsRuntimeContext;
    private Map<String, Object> serviceRuntimeContext;
    private Set<AWSLogReference> logReferences = new HashSet<AWSLogReference>();
    private String origin;

    public AWSXRayRecorder() {
        Optional<ContextMissingStrategy> environmentContextMissingStrategy = AWSXRayRecorderBuilder.contextMissingStrategyFromEnvironmentVariable();
        Optional<ContextMissingStrategy> systemContextMissingStrategy = AWSXRayRecorderBuilder.contextMissingStrategyFromSystemProperty();
        if (environmentContextMissingStrategy.isPresent()) {
            logger.info("Overriding contextMissingStrategy. Environment variable AWS_XRAY_CONTEXT_MISSING has value: \"" + System.getenv("AWS_XRAY_CONTEXT_MISSING") + "\".");
            this.contextMissingStrategy = environmentContextMissingStrategy.get();
        } else if (systemContextMissingStrategy.isPresent()) {
            logger.info("Overriding contextMissingStrategy. System property com.amazonaws.xray.strategy.contextMissingStrategy has value: \"" + System.getProperty("com.amazonaws.xray.strategy.contextMissingStrategy") + "\".");
            this.contextMissingStrategy = systemContextMissingStrategy.get();
        }
        this.segmentContextResolverChain = new SegmentContextResolverChain();
        this.segmentContextResolverChain.addResolver(new LambdaSegmentContextResolver());
        this.segmentContextResolverChain.addResolver(new ThreadLocalSegmentContextResolver());
        this.segmentListeners = new ArrayList();
        this.awsRuntimeContext = new ConcurrentHashMap<String, Object>();
        this.awsRuntimeContext.put("xray", SDK_VERSION_INFORMATION);
        this.serviceRuntimeContext = new ConcurrentHashMap<String, Object>();
        this.serviceRuntimeContext.putAll(RUNTIME_INFORMATION);
        try {
            this.emitter = new DefaultEmitter();
        }
        catch (SocketException e) {
            throw new RuntimeException("Unable to instantiate AWSXRayRecorder: ", e);
        }
    }

    public boolean sendSegment(Segment segment) {
        if (segment.isSampled()) {
            return this.emitter.sendSegment(segment);
        }
        return false;
    }

    public boolean sendSubsegment(Subsegment subsegment) {
        if (subsegment.getParentSegment().isSampled()) {
            return this.emitter.sendSubsegment(subsegment);
        }
        return false;
    }

    public <R> R createSegment(String name, Function<Segment, R> function) {
        Segment segment = this.beginSegment(name);
        try {
            R r = function.apply(segment);
            return r;
        }
        catch (Exception e) {
            segment.addException(e);
            throw e;
        }
        finally {
            this.endSegment();
        }
    }

    public void createSegment(String name, Consumer<Segment> consumer) {
        Segment segment = this.beginSegment(name);
        try {
            consumer.accept(segment);
        }
        catch (Exception e) {
            segment.addException(e);
            throw e;
        }
        finally {
            this.endSegment();
        }
    }

    public <R> R createSegment(String name, Supplier<R> supplier) {
        Segment segment = this.beginSegment(name);
        try {
            R r = supplier.get();
            return r;
        }
        catch (Exception e) {
            segment.addException(e);
            throw e;
        }
        finally {
            this.endSegment();
        }
    }

    public void createSegment(String name, Runnable runnable) {
        Segment segment = this.beginSegment(name);
        try {
            runnable.run();
        }
        catch (Exception e) {
            segment.addException(e);
            throw e;
        }
        finally {
            this.endSegment();
        }
    }

    public <R> R createSubsegment(String name, Function<Subsegment, R> function) {
        Subsegment subsegment = this.beginSubsegment(name);
        try {
            R r = function.apply(subsegment);
            return r;
        }
        catch (Exception e) {
            if (subsegment != null) {
                subsegment.addException(e);
            }
            throw e;
        }
        finally {
            this.endSubsegment();
        }
    }

    public void createSubsegment(String name, Consumer<Subsegment> consumer) {
        Subsegment subsegment = this.beginSubsegment(name);
        try {
            consumer.accept(subsegment);
        }
        catch (Exception e) {
            if (subsegment != null) {
                subsegment.addException(e);
            }
            throw e;
        }
        finally {
            this.endSubsegment();
        }
    }

    public <R> R createSubsegment(String name, Supplier<R> supplier) {
        Subsegment subsegment = this.beginSubsegment(name);
        try {
            R r = supplier.get();
            return r;
        }
        catch (Exception e) {
            if (subsegment != null) {
                subsegment.addException(e);
            }
            throw e;
        }
        finally {
            this.endSubsegment();
        }
    }

    public void createSubsegment(String name, Runnable runnable) {
        Subsegment subsegment = this.beginSubsegment(name);
        try {
            runnable.run();
        }
        catch (Exception e) {
            if (subsegment != null) {
                subsegment.addException(e);
            }
            throw e;
        }
        finally {
            this.endSubsegment();
        }
    }

    public Segment beginSegment(String name) {
        return this.beginSegment(new SegmentImpl(this, name));
    }

    public Segment beginSegment(String name, TraceID traceId, String parentId) {
        SegmentImpl segment = new SegmentImpl(this, name, traceId);
        segment.setParentId(parentId);
        return this.beginSegment(segment);
    }

    public Segment beginDummySegment() {
        return this.beginSegment(new DummySegment(this));
    }

    public Segment beginDummySegment(String name, TraceID traceId) {
        return this.beginSegment(new DummySegment(this, name, traceId));
    }

    public Segment beginDummySegment(TraceID traceId) {
        return this.beginSegment(new DummySegment(this, traceId));
    }

    private Segment beginSegment(Segment segment) {
        SegmentContext context = this.getSegmentContext();
        if (null == context) {
            return null;
        }
        Entity current = this.getTraceEntity();
        if (current != null) {
            logger.error("Beginning new segment while another segment exists in the segment context. Overwriting current segment named '" + current.getName() + "' to start new segment named '" + segment.getName() + "'.");
        }
        segment.setAws(this.getAwsRuntimeContext());
        if (null != this.getOrigin()) {
            segment.setOrigin(this.getOrigin());
        }
        segment.putAllService(this.getServiceRuntimeContext());
        if (null != this.logReferences && !this.logReferences.isEmpty()) {
            segment.putAws(CW_LOGS_KEY, this.logReferences);
        }
        this.setTraceEntity(segment);
        this.segmentListeners.stream().filter(Objects::nonNull).forEach(listener -> listener.onBeginSegment(segment));
        return context.beginSegment(this, segment);
    }

    public void endSegment() {
        Entity current;
        SegmentContext context = this.getSegmentContext();
        if (null != context) {
            context.endSegment(this);
        }
        if ((current = this.getTraceEntity()) != null) {
            Segment segment = current.getParentSegment();
            logger.debug("Ending segment named '" + segment.getName() + "'.");
            this.segmentListeners.stream().filter(Objects::nonNull).forEach(listener -> listener.beforeEndSegment(segment));
            if (segment.end()) {
                this.sendSegment(segment);
            } else {
                logger.debug("Not emitting segment named '" + segment.getName() + "' as it parents in-progress subsegments.");
            }
            this.segmentListeners.stream().filter(Objects::nonNull).forEach(listener -> listener.afterEndSegment(segment));
            this.clearTraceEntity();
        } else {
            this.getContextMissingStrategy().contextMissing("Failed to end segment: segment cannot be found.", SegmentNotFoundException.class);
        }
    }

    public void endSubsegment(Subsegment subsegment) {
        if (subsegment == null) {
            logger.debug("No input subsegment to end. No-op.");
            return;
        }
        boolean rootReady = subsegment.end();
        if (subsegment.getParent() instanceof FacadeSegment) {
            if (((FacadeSegment)subsegment.getParent()).isSampled()) {
                this.getEmitter().sendSubsegment(subsegment);
            }
            return;
        }
        if (rootReady && !(subsegment.getParentSegment() instanceof FacadeSegment)) {
            this.sendSegment(subsegment.getParentSegment());
            return;
        }
        if (this.getStreamingStrategy().requiresStreaming(subsegment.getParentSegment())) {
            this.getStreamingStrategy().streamSome(subsegment.getParentSegment(), this.getEmitter());
        }
    }

    public Subsegment beginSubsegment(String name) {
        SegmentContext context = this.getSegmentContext();
        if (null != context) {
            return this.segmentContextResolverChain.resolve().beginSubsegment(this, name);
        }
        return null;
    }

    public void endSubsegment() {
        SegmentContext context = this.getSegmentContext();
        if (null != context) {
            this.segmentContextResolverChain.resolve().endSubsegment(this);
        }
    }

    public Segment getCurrentSegment() {
        Optional<Segment> segment = this.getCurrentSegmentOptional();
        if (segment.isPresent()) {
            return segment.get();
        }
        this.contextMissingStrategy.contextMissing("No segment in progress.", SegmentNotFoundException.class);
        return null;
    }

    public Optional<Segment> getCurrentSegmentOptional() {
        SegmentContext context = this.segmentContextResolverChain.resolve();
        if (null == context) {
            return Optional.empty();
        }
        Entity current = context.getTraceEntity();
        if (current instanceof Segment) {
            return Optional.of((Segment)current);
        }
        if (current instanceof Subsegment) {
            return Optional.of(current.getParentSegment());
        }
        return Optional.empty();
    }

    public Subsegment getCurrentSubsegment() {
        SegmentContext context = this.getSegmentContext();
        if (null == context) {
            return null;
        }
        Entity current = context.getTraceEntity();
        if (null == current) {
            this.contextMissingStrategy.contextMissing("No segment in progress.", SegmentNotFoundException.class);
        } else {
            if (current instanceof Subsegment) {
                return (Subsegment)current;
            }
            this.contextMissingStrategy.contextMissing("No subsegment in progress.", SubsegmentNotFoundException.class);
        }
        return null;
    }

    public Optional<Subsegment> getCurrentSubsegmentOptional() {
        SegmentContext context = this.segmentContextResolverChain.resolve();
        if (null == context) {
            return Optional.empty();
        }
        Entity current = context.getTraceEntity();
        if (current instanceof Subsegment) {
            return Optional.of((Subsegment)current);
        }
        return Optional.empty();
    }

    @Deprecated
    public void injectThreadLocal(Entity entity) {
        ThreadLocalStorage.set(entity);
    }

    @Deprecated
    public Entity getThreadLocal() {
        return ThreadLocalStorage.get();
    }

    @Deprecated
    public void clearThreadLocal() {
        ThreadLocalStorage.clear();
    }

    private SegmentContext getSegmentContext() {
        SegmentContext context = this.segmentContextResolverChain.resolve();
        if (null == context) {
            this.contextMissingStrategy.contextMissing("Segment context not found.", SegmentNotFoundException.class);
            return null;
        }
        return context;
    }

    public void setTraceEntity(Entity entity) {
        SegmentContext context = this.getSegmentContext();
        if (null == context) {
            return;
        }
        context.setTraceEntity(entity);
    }

    public Entity getTraceEntity() {
        SegmentContext context = this.getSegmentContext();
        if (null == context) {
            return null;
        }
        return context.getTraceEntity();
    }

    public void clearTraceEntity() {
        SegmentContext context = this.getSegmentContext();
        if (null == context) {
            return;
        }
        context.clearTraceEntity();
    }

    public void putRuntimeContext(String key, Object value) {
        if (null == value) {
            value = "";
        }
        this.awsRuntimeContext.put(key, value);
    }

    public void addAllLogReferences(Set<AWSLogReference> logReferences) {
        this.logReferences.addAll(logReferences);
    }

    public SamplingStrategy getSamplingStrategy() {
        return this.samplingStrategy;
    }

    public void setSamplingStrategy(SamplingStrategy samplingStrategy) {
        this.samplingStrategy = samplingStrategy;
    }

    public StreamingStrategy getStreamingStrategy() {
        return this.streamingStrategy;
    }

    public void setStreamingStrategy(StreamingStrategy streamingStrategy) {
        this.streamingStrategy = streamingStrategy;
    }

    public PrioritizationStrategy getPrioritizationStrategy() {
        return this.prioritizationStrategy;
    }

    public void setPrioritizationStrategy(PrioritizationStrategy prioritizationStrategy) {
        this.prioritizationStrategy = prioritizationStrategy;
    }

    public ThrowableSerializationStrategy getThrowableSerializationStrategy() {
        return this.throwableSerializationStrategy;
    }

    public void setThrowableSerializationStrategy(ThrowableSerializationStrategy throwableSerializationStrategy) {
        this.throwableSerializationStrategy = throwableSerializationStrategy;
    }

    public ContextMissingStrategy getContextMissingStrategy() {
        return this.contextMissingStrategy;
    }

    public void setContextMissingStrategy(ContextMissingStrategy contextMissingStrategy) {
        this.contextMissingStrategy = contextMissingStrategy;
    }

    public SegmentContextResolverChain getSegmentContextResolverChain() {
        return this.segmentContextResolverChain;
    }

    public void setSegmentContextResolverChain(SegmentContextResolverChain segmentContextResolverChain) {
        this.segmentContextResolverChain = segmentContextResolverChain;
    }

    public Emitter getEmitter() {
        return this.emitter;
    }

    public void setEmitter(Emitter emitter) {
        this.emitter = emitter;
    }

    public ArrayList<SegmentListener> getSegmentListeners() {
        return this.segmentListeners;
    }

    public void addSegmentListener(SegmentListener segmentListener) {
        this.segmentListeners.add(segmentListener);
    }

    public void addAllSegmentListeners(Collection<SegmentListener> segmentListeners) {
        this.segmentListeners.addAll(segmentListeners);
    }

    public Map<String, Object> getAwsRuntimeContext() {
        return this.awsRuntimeContext;
    }

    public Map<String, Object> getServiceRuntimeContext() {
        return this.serviceRuntimeContext;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public boolean forceSamplingOfCurrentSegment() {
        Segment segment;
        if (this.samplingStrategy.isForcedSamplingSupported() && !(segment = this.getCurrentSegment()).isSampled()) {
            segment.setSampled(true);
            return true;
        }
        return false;
    }

    public String currentEntityId() {
        SegmentContext context = this.getSegmentContext();
        if (null == context) {
            return null;
        }
        Entity current = context.getTraceEntity();
        if (null != current) {
            return current.getId();
        }
        this.contextMissingStrategy.contextMissing("Failed to get current entity ID: segment or subsegment cannot be found.", SegmentNotFoundException.class);
        return null;
    }

    public TraceID currentTraceId() {
        SegmentContext context = this.getSegmentContext();
        if (null == context) {
            return null;
        }
        Entity current = context.getTraceEntity();
        if (null != current) {
            return current.getParentSegment().getTraceId();
        }
        this.contextMissingStrategy.contextMissing("Failed to get current trace ID: segment cannot be found.", SegmentNotFoundException.class);
        return null;
    }

    public String currentFormattedId() {
        SegmentContext context = this.getSegmentContext();
        if (null == context) {
            return null;
        }
        Entity current = context.getTraceEntity();
        if (null != current) {
            TraceID traceId = current.getParentSegment().getTraceId();
            String entityId = current.getId();
            return traceId.toString() + "@" + entityId;
        }
        this.contextMissingStrategy.contextMissing("Failed to get current formatted ID: segment cannot be found.", SegmentNotFoundException.class);
        return null;
    }

    static {
        String javaVmName;
        logger = LogFactory.getLog(AWSXRayRecorder.class);
        SDK_VERSION_INFORMATION = new HashMap<String, Object>();
        RUNTIME_INFORMATION = new HashMap<String, Object>();
        InputStream propertiesStream = AWSXRayRecorder.class.getResourceAsStream(PROPERTIES_LOCATION);
        Properties properties2 = new Properties();
        try {
            properties2.load(propertiesStream);
        }
        catch (IOException | IllegalArgumentException | NullPointerException e) {
            logger.warn("Unable to detect SDK version.", e);
        }
        String sdkVersion = DEFAULT_SDK_VERSION;
        if (null != properties2.getProperty(SDK_VERSION_KEY)) {
            sdkVersion = properties2.getProperty(SDK_VERSION_KEY);
        }
        SDK_VERSION_INFORMATION.put("sdk", SDK);
        SDK_VERSION_INFORMATION.put("sdk_version", sdkVersion);
        String javaVersion = System.getProperty("java.version");
        if (null != javaVersion) {
            RUNTIME_INFORMATION.put("runtime_version", javaVersion);
        }
        if (null != (javaVmName = System.getProperty("java.vm.name"))) {
            RUNTIME_INFORMATION.put("runtime", System.getProperty("java.vm.name"));
        }
    }
}

