/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.sns.model.SubscribeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Map;

public class SubscribeRequestMarshaller
implements Marshaller<Request<SubscribeRequest>, SubscribeRequest> {
    @Override
    public Request<SubscribeRequest> marshall(SubscribeRequest subscribeRequest) {
        if (subscribeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SubscribeRequest> request = new DefaultRequest<SubscribeRequest>(subscribeRequest, "AmazonSNS");
        request.addParameter("Action", "Subscribe");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (subscribeRequest.getTopicArn() != null) {
            request.addParameter("TopicArn", StringUtils.fromString(subscribeRequest.getTopicArn()));
        }
        if (subscribeRequest.getProtocol() != null) {
            request.addParameter("Protocol", StringUtils.fromString(subscribeRequest.getProtocol()));
        }
        if (subscribeRequest.getEndpoint() != null) {
            request.addParameter("Endpoint", StringUtils.fromString(subscribeRequest.getEndpoint()));
        }
        Map<String, String> attributes = subscribeRequest.getAttributes();
        int attributesListIndex = 1;
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            if (entry.getKey() != null) {
                request.addParameter("Attributes.entry." + attributesListIndex + ".key", StringUtils.fromString(entry.getKey()));
            }
            if (entry.getValue() != null) {
                request.addParameter("Attributes.entry." + attributesListIndex + ".value", StringUtils.fromString(entry.getValue()));
            }
            ++attributesListIndex;
        }
        if (subscribeRequest.getReturnSubscriptionArn() != null) {
            request.addParameter("ReturnSubscriptionArn", StringUtils.fromBoolean(subscribeRequest.getReturnSubscriptionArn()));
        }
        return request;
    }
}

