/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.services.cloudformation.model.Parameter;
import com.amazonaws.services.cloudformation.model.StackInstance;
import com.amazonaws.services.cloudformation.model.transform.ParameterStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class StackInstanceStaxUnmarshaller
implements Unmarshaller<StackInstance, StaxUnmarshallerContext> {
    private static StackInstanceStaxUnmarshaller instance;

    @Override
    public StackInstance unmarshall(StaxUnmarshallerContext context) throws Exception {
        StackInstance stackInstance = new StackInstance();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return stackInstance;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("StackSetId", targetDepth)) {
                    stackInstance.setStackSetId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Region", targetDepth)) {
                    stackInstance.setRegion(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Account", targetDepth)) {
                    stackInstance.setAccount(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("StackId", targetDepth)) {
                    stackInstance.setStackId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ParameterOverrides", targetDepth)) {
                    stackInstance.withParameterOverrides(new ArrayList<Parameter>());
                    continue;
                }
                if (context.testExpression("ParameterOverrides/member", targetDepth)) {
                    stackInstance.withParameterOverrides(ParameterStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Status", targetDepth)) {
                    stackInstance.setStatus(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("StatusReason", targetDepth)) {
                    stackInstance.setStatusReason(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("OrganizationalUnitId", targetDepth)) {
                    stackInstance.setOrganizationalUnitId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DriftStatus", targetDepth)) {
                    stackInstance.setDriftStatus(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("LastDriftCheckTimestamp", targetDepth)) continue;
                stackInstance.setLastDriftCheckTimestamp(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance("iso8601").unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return stackInstance;
    }

    public static StackInstanceStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new StackInstanceStaxUnmarshaller();
        }
        return instance;
    }
}

