/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudformation.model.TypeSummary;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListTypesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private SdkInternalList<TypeSummary> typeSummaries;
    private String nextToken;

    public List<TypeSummary> getTypeSummaries() {
        if (this.typeSummaries == null) {
            this.typeSummaries = new SdkInternalList();
        }
        return this.typeSummaries;
    }

    public void setTypeSummaries(Collection<TypeSummary> typeSummaries) {
        if (typeSummaries == null) {
            this.typeSummaries = null;
            return;
        }
        this.typeSummaries = new SdkInternalList<TypeSummary>(typeSummaries);
    }

    public ListTypesResult withTypeSummaries(TypeSummary ... typeSummaries) {
        if (this.typeSummaries == null) {
            this.setTypeSummaries(new SdkInternalList<TypeSummary>(typeSummaries.length));
        }
        for (TypeSummary ele : typeSummaries) {
            this.typeSummaries.add(ele);
        }
        return this;
    }

    public ListTypesResult withTypeSummaries(Collection<TypeSummary> typeSummaries) {
        this.setTypeSummaries(typeSummaries);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListTypesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTypeSummaries() != null) {
            sb.append("TypeSummaries: ").append(this.getTypeSummaries()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTypesResult)) {
            return false;
        }
        ListTypesResult other = (ListTypesResult)obj;
        if (other.getTypeSummaries() == null ^ this.getTypeSummaries() == null) {
            return false;
        }
        if (other.getTypeSummaries() != null && !other.getTypeSummaries().equals(this.getTypeSummaries())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode2 = 1;
        hashCode2 = 31 * hashCode2 + (this.getTypeSummaries() == null ? 0 : this.getTypeSummaries().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode2;
    }

    public ListTypesResult clone() {
        try {
            return (ListTypesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

