/*
 * Decompiled with CFR 0.152.
 */
package pl.wrzasq.commons.aws;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageHandler<Type> {
    private Logger logger = LoggerFactory.getLogger(MessageHandler.class);
    private ObjectMapper objectMapper;
    private Consumer<Type> messageHandler;
    private Class<Type> type;

    public MessageHandler(ObjectMapper objectMapper, Consumer<Type> messageHandler, Class<Type> type2) {
        this.objectMapper = objectMapper;
        this.messageHandler = messageHandler;
        this.type = type2;
    }

    public void handle(String message) {
        this.logger.info("Incoming message {}.", (Object)message);
        try {
            Type data2 = this.objectMapper.readValue(message, this.type);
            this.messageHandler.accept(data2);
            this.logger.debug("Task processed.");
        }
        catch (IOException error) {
            this.logger.error("Failed to parse event data.", error);
            throw new IllegalArgumentException("Could not parse event data.", error);
        }
    }
}

