/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DockerUtils {
    private static final Log logger = LogFactory.getLog(DockerUtils.class);
    private static final String CGROUP_PATH = "/proc/self/cgroup";
    private static final int CONTAINER_ID_LENGTH = 64;
    private URL cgroupLocation;

    public DockerUtils() {
        try {
            this.cgroupLocation = new File(CGROUP_PATH).toURI().toURL();
        }
        catch (MalformedURLException e) {
            logger.warn("Failed to read container ID because /proc/self/cgroup does not exist.");
        }
    }

    public DockerUtils(URL cgroupLocation) {
        this.cgroupLocation = cgroupLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContainerId() throws IOException {
        File procFile;
        if (this.cgroupLocation == null) {
            return null;
        }
        try {
            procFile = new File(this.cgroupLocation.toURI());
        }
        catch (URISyntaxException e) {
            logger.warn("Failed to read container ID because " + this.cgroupLocation.toString() + " didn't contain an ID.");
            return null;
        }
        if (procFile.exists()) {
            FileInputStream inputStream = null;
            BufferedReader reader = null;
            try {
                String line;
                inputStream = new FileInputStream(procFile);
                reader = new BufferedReader(new InputStreamReader(inputStream));
                do {
                    if ((line = reader.readLine()) == null) {
                        logger.warn("Failed to read container ID because " + this.cgroupLocation.toString() + " didn't contain an ID.");
                        continue;
                    }
                    if (line.length() <= 64) continue;
                    String string = line.substring(line.length() - 64);
                    return string;
                } while (line != null);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
                if (inputStream != null) {
                    ((InputStream)inputStream).close();
                }
            }
        } else {
            logger.warn("Failed to read container ID because " + this.cgroupLocation.toString() + " does not exist.");
        }
        return null;
    }
}

