/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.strategy.sampling;

import com.amazonaws.services.xray.AWSXRay;
import com.amazonaws.xray.strategy.sampling.LocalizedSamplingStrategy;
import com.amazonaws.xray.strategy.sampling.SamplingRequest;
import com.amazonaws.xray.strategy.sampling.SamplingResponse;
import com.amazonaws.xray.strategy.sampling.SamplingStrategy;
import com.amazonaws.xray.strategy.sampling.XRayClient;
import com.amazonaws.xray.strategy.sampling.manifest.CentralizedManifest;
import com.amazonaws.xray.strategy.sampling.pollers.RulePoller;
import com.amazonaws.xray.strategy.sampling.pollers.TargetPoller;
import com.amazonaws.xray.strategy.sampling.rule.CentralizedRule;
import com.amazonaws.xray.utils.ByteUtils;
import java.net.URL;
import java.security.SecureRandom;
import java.time.Clock;
import java.time.Instant;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CentralizedSamplingStrategy
implements SamplingStrategy {
    private static Log logger = LogFactory.getLog(TargetPoller.class);
    private static String clientID;
    private boolean isStarted = false;
    private CentralizedManifest manifest = new CentralizedManifest();
    private LocalizedSamplingStrategy fallback;
    private RulePoller rulePoller;
    private TargetPoller targetPoller;
    private AWSXRay client;

    public CentralizedSamplingStrategy() {
        this.fallback = new LocalizedSamplingStrategy();
        this.client = XRayClient.newClient();
        this.rulePoller = new RulePoller(this.manifest, this.client, Clock.systemUTC());
        this.targetPoller = new TargetPoller(this.manifest, this.client, Clock.systemUTC());
    }

    public CentralizedSamplingStrategy(URL ruleLocation) {
        this.fallback = new LocalizedSamplingStrategy(ruleLocation);
        this.client = XRayClient.newClient();
        this.rulePoller = new RulePoller(this.manifest, this.client, Clock.systemUTC());
        this.targetPoller = new TargetPoller(this.manifest, this.client, Clock.systemUTC());
    }

    @Override
    public SamplingResponse shouldTrace(SamplingRequest samplingRequest) {
        if (!this.isStarted) {
            this.startPoller();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Determining shouldTrace decision for:\n\tserviceName: " + samplingRequest.getService().orElse("") + "\n\thost: " + samplingRequest.getHost().orElse("") + "\n\tpath: " + samplingRequest.getUrl().orElse("") + "\n\tmethod: " + samplingRequest.getMethod().orElse("") + "\n\tserviceType: " + samplingRequest.getServiceType().orElse(""));
        }
        if (this.manifest.isExpired(Instant.now())) {
            logger.debug("Centralized sampling data expired. Using fallback sampling strategy.");
            return this.fallback.shouldTrace(samplingRequest);
        }
        for (CentralizedRule rule : this.manifest.getRules().values()) {
            boolean applicable = rule.match(samplingRequest);
            if (!applicable) continue;
            logger.debug("Applicable rule:" + rule.getName());
            return rule.sample(Instant.now());
        }
        CentralizedRule dRule = this.manifest.getDefaultRule();
        if (dRule != null) {
            logger.debug("Applicable default rule: " + dRule.getName());
            return dRule.sample(Instant.now());
        }
        logger.debug("Centralized default sampling rule unavailable. Using fallback sampling strategy.");
        SamplingResponse sampleResponse = this.fallback.shouldTrace(samplingRequest);
        return sampleResponse;
    }

    @Override
    public void shutdown() {
        this.rulePoller.shutdown();
        this.targetPoller.shutdown();
    }

    public static String getClientID() {
        return clientID;
    }

    private synchronized void startPoller() {
        if (this.isStarted) {
            return;
        }
        this.rulePoller.start();
        this.targetPoller.start();
        this.isStarted = true;
    }

    @Override
    public boolean isForcedSamplingSupported() {
        return false;
    }

    static {
        SecureRandom rand = new SecureRandom();
        byte[] bytes = new byte[12];
        rand.nextBytes(bytes);
        clientID = ByteUtils.byteArrayToHexString(bytes);
    }
}

