/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.strategy;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.xray.entities.Entity;
import com.amazonaws.xray.entities.Subsegment;
import com.amazonaws.xray.entities.ThrowableDescription;
import com.amazonaws.xray.strategy.ThrowableSerializationStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultThrowableSerializationStrategy
implements ThrowableSerializationStrategy {
    private static final Log logger = LogFactory.getLog(DefaultThrowableSerializationStrategy.class);
    private static final int DEFAULT_MAX_STACK_TRACE_LENGTH = 50;
    private static Set<Class<? extends Throwable>> DEFAULT_REMOTE_EXCEPTION_CLASSES = new HashSet<Class<? extends Throwable>>();
    private int maxStackTraceLength;
    private Set<Class<? extends Throwable>> remoteExceptionClasses = new HashSet<Class<? extends Throwable>>();

    public DefaultThrowableSerializationStrategy() {
        this(50);
    }

    public DefaultThrowableSerializationStrategy(int maxStackTraceLength) {
        this(maxStackTraceLength, DEFAULT_REMOTE_EXCEPTION_CLASSES);
    }

    public DefaultThrowableSerializationStrategy(int maxStackTraceLength, Set<Class<? extends Throwable>> remoteExceptionClasses) {
        this.maxStackTraceLength = maxStackTraceLength;
        this.remoteExceptionClasses = remoteExceptionClasses;
    }

    private boolean isRemote(Throwable throwable) {
        return this.remoteExceptionClasses.parallelStream().anyMatch(remoteExceptionClass -> remoteExceptionClass.isInstance(throwable));
    }

    private Optional<ThrowableDescription> referenceInChildren(Throwable throwable, List<Subsegment> subsegments) {
        return subsegments.parallelStream().flatMap(subsegment -> subsegment.getCause().getExceptions().stream()).filter(throwableDescription -> throwable.equals(throwableDescription.getThrowable())).findAny();
    }

    private ThrowableDescription describeThrowable(Throwable throwable, String id) {
        ThrowableDescription description2 = new ThrowableDescription();
        description2.setId(id);
        description2.setMessage(throwable.getMessage());
        description2.setType(throwable.getClass().getName());
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        if (stackTrace.length > this.maxStackTraceLength) {
            description2.setStack(Arrays.copyOfRange(stackTrace, 0, this.maxStackTraceLength));
            description2.setTruncated(stackTrace.length - this.maxStackTraceLength);
        } else {
            description2.setStack(stackTrace);
        }
        description2.setThrowable(throwable);
        if (this.isRemote(throwable)) {
            description2.setRemote(true);
        }
        return description2;
    }

    @Override
    public List<ThrowableDescription> describeInContext(Throwable throwable, List<Subsegment> subsegments) {
        ArrayList<ThrowableDescription> result2 = new ArrayList<ThrowableDescription>();
        ThrowableDescription description2 = new ThrowableDescription();
        Optional<ThrowableDescription> exceptionReferenced = this.referenceInChildren(throwable, subsegments);
        if (exceptionReferenced.isPresent()) {
            description2.setCause(null == exceptionReferenced.get().getId() ? exceptionReferenced.get().getCause() : exceptionReferenced.get().getId());
            description2.setThrowable(throwable);
            result2.add(description2);
            return result2;
        }
        description2 = this.describeThrowable(throwable, Entity.generateId());
        result2.add(description2);
        for (Throwable nextNode = throwable.getCause(); null != nextNode; nextNode = nextNode.getCause()) {
            Throwable currentNode = nextNode;
            exceptionReferenced = this.referenceInChildren(currentNode, subsegments);
            if (exceptionReferenced.isPresent()) {
                description2.setCause(null == exceptionReferenced.get().getId() ? exceptionReferenced.get().getCause() : exceptionReferenced.get().getId());
            } else {
                String newId = Entity.generateId();
                description2.setCause(newId);
                description2 = this.describeThrowable(currentNode, newId);
            }
            result2.add(description2);
        }
        return result2;
    }

    public int getMaxStackTraceLength() {
        return this.maxStackTraceLength;
    }

    static {
        DEFAULT_REMOTE_EXCEPTION_CLASSES.add(AmazonServiceException.class);
    }
}

