/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.emitters;

import com.amazonaws.xray.config.DaemonConfiguration;
import com.amazonaws.xray.emitters.Emitter;
import com.amazonaws.xray.entities.Entity;
import com.amazonaws.xray.entities.Segment;
import com.amazonaws.xray.entities.Subsegment;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UDPEmitter
extends Emitter {
    private static final Log logger = LogFactory.getLog(UDPEmitter.class);
    private DatagramSocket daemonSocket;
    private DaemonConfiguration config;
    private byte[] sendBuffer = new byte[262144];

    public UDPEmitter() throws SocketException {
        this(new DaemonConfiguration());
    }

    public UDPEmitter(DaemonConfiguration config) throws SocketException {
        this.config = config;
        try {
            this.daemonSocket = new DatagramSocket();
        }
        catch (SocketException e) {
            logger.error("Exception while instantiating daemon socket.", e);
            throw e;
        }
    }

    @Override
    public boolean sendSegment(Segment segment) {
        if (logger.isDebugEnabled()) {
            logger.debug(segment.prettySerialize());
        }
        return this.sendData(("{\"format\": \"json\", \"version\": 1}\n" + segment.serialize()).getBytes(), segment);
    }

    @Override
    public boolean sendSubsegment(Subsegment subsegment) {
        if (logger.isDebugEnabled()) {
            logger.debug(subsegment.prettyStreamSerialize());
        }
        return this.sendData(("{\"format\": \"json\", \"version\": 1}\n" + subsegment.streamSerialize()).getBytes(), subsegment);
    }

    private boolean sendData(byte[] data2, Entity entity) {
        DatagramPacket packet = new DatagramPacket(this.sendBuffer, 262144, this.config.getAddressForEmitter());
        packet.setData(data2);
        try {
            logger.debug("Sending UDP packet.");
            this.daemonSocket.send(packet);
        }
        catch (IOException e) {
            String segmentName = Optional.ofNullable(entity.getParent()).map(this::nameAndId).orElse("[no parent segment]");
            logger.error("Exception while sending segment over UDP for entity " + this.nameAndId(entity) + " on segment " + segmentName, e);
            return false;
        }
        return true;
    }

    private String nameAndId(Entity entity) {
        return entity.getName() + " [" + entity.getId() + "]";
    }
}

