/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.xray.model.Http;
import com.amazonaws.services.xray.model.ServiceId;
import com.amazonaws.services.xray.model.TraceUser;
import com.amazonaws.services.xray.model.ValueWithServiceIds;
import com.amazonaws.services.xray.model.transform.TraceSummaryMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TraceSummary
implements Serializable,
Cloneable,
StructuredPojo {
    private String id;
    private Double duration;
    private Double responseTime;
    private Boolean hasFault;
    private Boolean hasError;
    private Boolean hasThrottle;
    private Boolean isPartial;
    private Http http;
    private Map<String, List<ValueWithServiceIds>> annotations;
    private List<TraceUser> users;
    private List<ServiceId> serviceIds;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public TraceSummary withId(String id) {
        this.setId(id);
        return this;
    }

    public void setDuration(Double duration) {
        this.duration = duration;
    }

    public Double getDuration() {
        return this.duration;
    }

    public TraceSummary withDuration(Double duration) {
        this.setDuration(duration);
        return this;
    }

    public void setResponseTime(Double responseTime) {
        this.responseTime = responseTime;
    }

    public Double getResponseTime() {
        return this.responseTime;
    }

    public TraceSummary withResponseTime(Double responseTime) {
        this.setResponseTime(responseTime);
        return this;
    }

    public void setHasFault(Boolean hasFault) {
        this.hasFault = hasFault;
    }

    public Boolean getHasFault() {
        return this.hasFault;
    }

    public TraceSummary withHasFault(Boolean hasFault) {
        this.setHasFault(hasFault);
        return this;
    }

    public Boolean isHasFault() {
        return this.hasFault;
    }

    public void setHasError(Boolean hasError) {
        this.hasError = hasError;
    }

    public Boolean getHasError() {
        return this.hasError;
    }

    public TraceSummary withHasError(Boolean hasError) {
        this.setHasError(hasError);
        return this;
    }

    public Boolean isHasError() {
        return this.hasError;
    }

    public void setHasThrottle(Boolean hasThrottle) {
        this.hasThrottle = hasThrottle;
    }

    public Boolean getHasThrottle() {
        return this.hasThrottle;
    }

    public TraceSummary withHasThrottle(Boolean hasThrottle) {
        this.setHasThrottle(hasThrottle);
        return this;
    }

    public Boolean isHasThrottle() {
        return this.hasThrottle;
    }

    public void setIsPartial(Boolean isPartial) {
        this.isPartial = isPartial;
    }

    public Boolean getIsPartial() {
        return this.isPartial;
    }

    public TraceSummary withIsPartial(Boolean isPartial) {
        this.setIsPartial(isPartial);
        return this;
    }

    public Boolean isPartial() {
        return this.isPartial;
    }

    public void setHttp(Http http) {
        this.http = http;
    }

    public Http getHttp() {
        return this.http;
    }

    public TraceSummary withHttp(Http http) {
        this.setHttp(http);
        return this;
    }

    public Map<String, List<ValueWithServiceIds>> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Map<String, List<ValueWithServiceIds>> annotations2) {
        this.annotations = annotations2;
    }

    public TraceSummary withAnnotations(Map<String, List<ValueWithServiceIds>> annotations2) {
        this.setAnnotations(annotations2);
        return this;
    }

    public TraceSummary addAnnotationsEntry(String key, List<ValueWithServiceIds> value) {
        if (null == this.annotations) {
            this.annotations = new HashMap<String, List<ValueWithServiceIds>>();
        }
        if (this.annotations.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.annotations.put(key, value);
        return this;
    }

    public TraceSummary clearAnnotationsEntries() {
        this.annotations = null;
        return this;
    }

    public List<TraceUser> getUsers() {
        return this.users;
    }

    public void setUsers(Collection<TraceUser> users) {
        if (users == null) {
            this.users = null;
            return;
        }
        this.users = new ArrayList<TraceUser>(users);
    }

    public TraceSummary withUsers(TraceUser ... users) {
        if (this.users == null) {
            this.setUsers(new ArrayList<TraceUser>(users.length));
        }
        for (TraceUser ele : users) {
            this.users.add(ele);
        }
        return this;
    }

    public TraceSummary withUsers(Collection<TraceUser> users) {
        this.setUsers(users);
        return this;
    }

    public List<ServiceId> getServiceIds() {
        return this.serviceIds;
    }

    public void setServiceIds(Collection<ServiceId> serviceIds) {
        if (serviceIds == null) {
            this.serviceIds = null;
            return;
        }
        this.serviceIds = new ArrayList<ServiceId>(serviceIds);
    }

    public TraceSummary withServiceIds(ServiceId ... serviceIds) {
        if (this.serviceIds == null) {
            this.setServiceIds(new ArrayList<ServiceId>(serviceIds.length));
        }
        for (ServiceId ele : serviceIds) {
            this.serviceIds.add(ele);
        }
        return this;
    }

    public TraceSummary withServiceIds(Collection<ServiceId> serviceIds) {
        this.setServiceIds(serviceIds);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getDuration() != null) {
            sb.append("Duration: ").append(this.getDuration()).append(",");
        }
        if (this.getResponseTime() != null) {
            sb.append("ResponseTime: ").append(this.getResponseTime()).append(",");
        }
        if (this.getHasFault() != null) {
            sb.append("HasFault: ").append(this.getHasFault()).append(",");
        }
        if (this.getHasError() != null) {
            sb.append("HasError: ").append(this.getHasError()).append(",");
        }
        if (this.getHasThrottle() != null) {
            sb.append("HasThrottle: ").append(this.getHasThrottle()).append(",");
        }
        if (this.getIsPartial() != null) {
            sb.append("IsPartial: ").append(this.getIsPartial()).append(",");
        }
        if (this.getHttp() != null) {
            sb.append("Http: ").append(this.getHttp()).append(",");
        }
        if (this.getAnnotations() != null) {
            sb.append("Annotations: ").append(this.getAnnotations()).append(",");
        }
        if (this.getUsers() != null) {
            sb.append("Users: ").append(this.getUsers()).append(",");
        }
        if (this.getServiceIds() != null) {
            sb.append("ServiceIds: ").append(this.getServiceIds());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TraceSummary)) {
            return false;
        }
        TraceSummary other = (TraceSummary)obj;
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getDuration() == null ^ this.getDuration() == null) {
            return false;
        }
        if (other.getDuration() != null && !other.getDuration().equals(this.getDuration())) {
            return false;
        }
        if (other.getResponseTime() == null ^ this.getResponseTime() == null) {
            return false;
        }
        if (other.getResponseTime() != null && !other.getResponseTime().equals(this.getResponseTime())) {
            return false;
        }
        if (other.getHasFault() == null ^ this.getHasFault() == null) {
            return false;
        }
        if (other.getHasFault() != null && !other.getHasFault().equals(this.getHasFault())) {
            return false;
        }
        if (other.getHasError() == null ^ this.getHasError() == null) {
            return false;
        }
        if (other.getHasError() != null && !other.getHasError().equals(this.getHasError())) {
            return false;
        }
        if (other.getHasThrottle() == null ^ this.getHasThrottle() == null) {
            return false;
        }
        if (other.getHasThrottle() != null && !other.getHasThrottle().equals(this.getHasThrottle())) {
            return false;
        }
        if (other.getIsPartial() == null ^ this.getIsPartial() == null) {
            return false;
        }
        if (other.getIsPartial() != null && !other.getIsPartial().equals(this.getIsPartial())) {
            return false;
        }
        if (other.getHttp() == null ^ this.getHttp() == null) {
            return false;
        }
        if (other.getHttp() != null && !other.getHttp().equals(this.getHttp())) {
            return false;
        }
        if (other.getAnnotations() == null ^ this.getAnnotations() == null) {
            return false;
        }
        if (other.getAnnotations() != null && !other.getAnnotations().equals(this.getAnnotations())) {
            return false;
        }
        if (other.getUsers() == null ^ this.getUsers() == null) {
            return false;
        }
        if (other.getUsers() != null && !other.getUsers().equals(this.getUsers())) {
            return false;
        }
        if (other.getServiceIds() == null ^ this.getServiceIds() == null) {
            return false;
        }
        return other.getServiceIds() == null || other.getServiceIds().equals(this.getServiceIds());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode2 = 1;
        hashCode2 = 31 * hashCode2 + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getDuration() == null ? 0 : this.getDuration().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getResponseTime() == null ? 0 : this.getResponseTime().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getHasFault() == null ? 0 : this.getHasFault().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getHasError() == null ? 0 : this.getHasError().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getHasThrottle() == null ? 0 : this.getHasThrottle().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getIsPartial() == null ? 0 : this.getIsPartial().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getHttp() == null ? 0 : this.getHttp().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getAnnotations() == null ? 0 : this.getAnnotations().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getUsers() == null ? 0 : this.getUsers().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getServiceIds() == null ? 0 : this.getServiceIds().hashCode());
        return hashCode2;
    }

    public TraceSummary clone() {
        try {
            return (TraceSummary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TraceSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

