/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.adapters.types.StringToInputStreamAdapter;
import java.io.InputStream;
import java.io.Serializable;

public class InvokeAsyncRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String functionName;
    private InputStream invokeArgs;

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public InvokeAsyncRequest withFunctionName(String functionName) {
        this.setFunctionName(functionName);
        return this;
    }

    public void setInvokeArgs(InputStream invokeArgs) {
        this.invokeArgs = invokeArgs;
    }

    public InputStream getInvokeArgs() {
        return this.invokeArgs;
    }

    public InvokeAsyncRequest withInvokeArgs(InputStream invokeArgs) {
        this.setInvokeArgs(invokeArgs);
        return this;
    }

    public void setInvokeArgs(String invokeArgs) {
        this.setInvokeArgs(new StringToInputStreamAdapter().adapt(invokeArgs));
    }

    public InvokeAsyncRequest withInvokeArgs(String invokeArgs) {
        this.setInvokeArgs(new StringToInputStreamAdapter().adapt(invokeArgs));
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFunctionName() != null) {
            sb.append("FunctionName: ").append(this.getFunctionName()).append(",");
        }
        if (this.getInvokeArgs() != null) {
            sb.append("InvokeArgs: ").append(this.getInvokeArgs());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeAsyncRequest)) {
            return false;
        }
        InvokeAsyncRequest other = (InvokeAsyncRequest)obj;
        if (other.getFunctionName() == null ^ this.getFunctionName() == null) {
            return false;
        }
        if (other.getFunctionName() != null && !other.getFunctionName().equals(this.getFunctionName())) {
            return false;
        }
        if (other.getInvokeArgs() == null ^ this.getInvokeArgs() == null) {
            return false;
        }
        return other.getInvokeArgs() == null || other.getInvokeArgs().equals(this.getInvokeArgs());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode2 = 1;
        hashCode2 = 31 * hashCode2 + (this.getFunctionName() == null ? 0 : this.getFunctionName().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getInvokeArgs() == null ? 0 : this.getInvokeArgs().hashCode());
        return hashCode2;
    }

    @Override
    public InvokeAsyncRequest clone() {
        return (InvokeAsyncRequest)super.clone();
    }
}

