/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lambda.model.transform.EnvironmentMarshaller;
import java.io.Serializable;
import java.util.Map;

public class Environment
implements Serializable,
Cloneable,
StructuredPojo {
    private SdkInternalMap<String, String> variables;

    public Map<String, String> getVariables() {
        if (this.variables == null) {
            this.variables = new SdkInternalMap();
        }
        return this.variables;
    }

    public void setVariables(Map<String, String> variables) {
        this.variables = variables == null ? null : new SdkInternalMap<String, String>(variables);
    }

    public Environment withVariables(Map<String, String> variables) {
        this.setVariables(variables);
        return this;
    }

    public Environment addVariablesEntry(String key, String value) {
        if (null == this.variables) {
            this.variables = new SdkInternalMap();
        }
        if (this.variables.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.variables.put(key, value);
        return this;
    }

    public Environment clearVariablesEntries() {
        this.variables = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVariables() != null) {
            sb.append("Variables: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Environment)) {
            return false;
        }
        Environment other = (Environment)obj;
        if (other.getVariables() == null ^ this.getVariables() == null) {
            return false;
        }
        return other.getVariables() == null || other.getVariables().equals(this.getVariables());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode2 = 1;
        hashCode2 = 31 * hashCode2 + (this.getVariables() == null ? 0 : this.getVariables().hashCode());
        return hashCode2;
    }

    public Environment clone() {
        try {
            return (Environment)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EnvironmentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

