/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lambda.model.transform.AliasRoutingConfigurationMarshaller;
import java.io.Serializable;
import java.util.Map;

public class AliasRoutingConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private SdkInternalMap<String, Double> additionalVersionWeights;

    public Map<String, Double> getAdditionalVersionWeights() {
        if (this.additionalVersionWeights == null) {
            this.additionalVersionWeights = new SdkInternalMap();
        }
        return this.additionalVersionWeights;
    }

    public void setAdditionalVersionWeights(Map<String, Double> additionalVersionWeights) {
        this.additionalVersionWeights = additionalVersionWeights == null ? null : new SdkInternalMap<String, Double>(additionalVersionWeights);
    }

    public AliasRoutingConfiguration withAdditionalVersionWeights(Map<String, Double> additionalVersionWeights) {
        this.setAdditionalVersionWeights(additionalVersionWeights);
        return this;
    }

    public AliasRoutingConfiguration addAdditionalVersionWeightsEntry(String key, Double value) {
        if (null == this.additionalVersionWeights) {
            this.additionalVersionWeights = new SdkInternalMap();
        }
        if (this.additionalVersionWeights.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.additionalVersionWeights.put(key, value);
        return this;
    }

    public AliasRoutingConfiguration clearAdditionalVersionWeightsEntries() {
        this.additionalVersionWeights = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAdditionalVersionWeights() != null) {
            sb.append("AdditionalVersionWeights: ").append(this.getAdditionalVersionWeights());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AliasRoutingConfiguration)) {
            return false;
        }
        AliasRoutingConfiguration other = (AliasRoutingConfiguration)obj;
        if (other.getAdditionalVersionWeights() == null ^ this.getAdditionalVersionWeights() == null) {
            return false;
        }
        return other.getAdditionalVersionWeights() == null || other.getAdditionalVersionWeights().equals(this.getAdditionalVersionWeights());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode2 = 1;
        hashCode2 = 31 * hashCode2 + (this.getAdditionalVersionWeights() == null ? 0 : this.getAdditionalVersionWeights().hashCode());
        return hashCode2;
    }

    public AliasRoutingConfiguration clone() {
        try {
            return (AliasRoutingConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AliasRoutingConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

