/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudformation.model.DescribeStackInstanceRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeStackInstanceRequestMarshaller
implements Marshaller<Request<DescribeStackInstanceRequest>, DescribeStackInstanceRequest> {
    @Override
    public Request<DescribeStackInstanceRequest> marshall(DescribeStackInstanceRequest describeStackInstanceRequest) {
        if (describeStackInstanceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeStackInstanceRequest> request = new DefaultRequest<DescribeStackInstanceRequest>(describeStackInstanceRequest, "AmazonCloudFormation");
        request.addParameter("Action", "DescribeStackInstance");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeStackInstanceRequest.getStackSetName() != null) {
            request.addParameter("StackSetName", StringUtils.fromString(describeStackInstanceRequest.getStackSetName()));
        }
        if (describeStackInstanceRequest.getStackInstanceAccount() != null) {
            request.addParameter("StackInstanceAccount", StringUtils.fromString(describeStackInstanceRequest.getStackInstanceAccount()));
        }
        if (describeStackInstanceRequest.getStackInstanceRegion() != null) {
            request.addParameter("StackInstanceRegion", StringUtils.fromString(describeStackInstanceRequest.getStackInstanceRegion()));
        }
        return request;
    }
}

