/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.components;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectClassUtilKt;
import org.jetbrains.annotations.NotNull;

final class SignatureSerializer {
    public static final SignatureSerializer INSTANCE;

    @NotNull
    public final String methodDesc(@NotNull Method method) {
        Intrinsics.checkParameterIsNotNull(method, "method");
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        Class<?>[] classArray = method.getParameterTypes();
        int n = classArray.length;
        for (int i = 0; i < n; ++i) {
            Class<?> parameterType;
            Class<?> clazz = parameterType = classArray[i];
            Intrinsics.checkExpressionValueIsNotNull(clazz, "parameterType");
            sb.append(ReflectClassUtilKt.getDesc(clazz));
        }
        sb.append(")");
        Class<?> clazz = method.getReturnType();
        Intrinsics.checkExpressionValueIsNotNull(clazz, "method.returnType");
        sb.append(ReflectClassUtilKt.getDesc(clazz));
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "sb.toString()");
        return string;
    }

    @NotNull
    public final String constructorDesc(@NotNull Constructor<?> constructor) {
        Intrinsics.checkParameterIsNotNull(constructor, "constructor");
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        Class<?>[] classArray = constructor.getParameterTypes();
        int n = classArray.length;
        for (int i = 0; i < n; ++i) {
            Class<?> parameterType;
            Class<?> clazz = parameterType = classArray[i];
            Intrinsics.checkExpressionValueIsNotNull(clazz, "parameterType");
            sb.append(ReflectClassUtilKt.getDesc(clazz));
        }
        sb.append(")V");
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "sb.toString()");
        return string;
    }

    @NotNull
    public final String fieldDesc(@NotNull Field field) {
        Intrinsics.checkParameterIsNotNull(field, "field");
        Class<?> clazz = field.getType();
        Intrinsics.checkExpressionValueIsNotNull(clazz, "field.type");
        return ReflectClassUtilKt.getDesc(clazz);
    }

    private SignatureSerializer() {
    }

    static {
        SignatureSerializer signatureSerializer;
        INSTANCE = signatureSerializer = new SignatureSerializer();
    }
}

