/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class JsonUtils {
    private static final JsonFactory jsonFactory = new JsonFactory();

    public static JsonNode getNodeFromJsonFile(String filePath, String fieldName) throws IOException {
        JsonParser jp = jsonFactory.createParser(new File(filePath));
        jp.setCodec(new ObjectMapper());
        JsonNode jsonNode = (JsonNode)jp.readValueAsTree();
        return jsonNode.findValue(fieldName);
    }

    public static List<String> getMatchingListFromJsonArrayNode(JsonNode rootNode, String fieldName) {
        ArrayList<String> retList = new ArrayList<String>();
        Iterator<JsonNode> ite = rootNode.elements();
        if (ite == null || !ite.hasNext()) {
            return retList;
        }
        ite.forEachRemaining(field -> {
            JsonNode stringNode = field.get(fieldName);
            if (stringNode != null && stringNode.textValue() != "") {
                retList.add(stringNode.textValue());
            }
        });
        return retList;
    }
}

