/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.strategy;

import com.amazonaws.xray.emitters.Emitter;
import com.amazonaws.xray.entities.Entity;
import com.amazonaws.xray.entities.Segment;
import com.amazonaws.xray.entities.Subsegment;
import com.amazonaws.xray.strategy.StreamingStrategy;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultStreamingStrategy
implements StreamingStrategy {
    private static final Log logger = LogFactory.getLog(DefaultStreamingStrategy.class);
    private static final int DEFAULT_MAX_SEGMENT_SIZE = 100;
    private final int maxSegmentSize;

    public DefaultStreamingStrategy() {
        this(100);
    }

    public DefaultStreamingStrategy(int maxSegmentSize) {
        if (maxSegmentSize < 0) {
            throw new IllegalArgumentException("maxSegmentSize must be a non-negative integer.");
        }
        this.maxSegmentSize = maxSegmentSize;
    }

    @Override
    public boolean requiresStreaming(Segment segment) {
        if (segment.isSampled() && null != segment.getTotalSize()) {
            return segment.getTotalSize().intValue() > this.maxSegmentSize;
        }
        return false;
    }

    @Override
    public void streamSome(Entity entity, Emitter emitter) {
        if (entity.getSubsegmentsLock().tryLock()) {
            try {
                this.stream(entity, emitter);
            }
            finally {
                entity.getSubsegmentsLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean stream(Entity entity, Emitter emitter) {
        ArrayList<Subsegment> children = new ArrayList<Subsegment>(entity.getSubsegments());
        ArrayList<Subsegment> streamable = new ArrayList<Subsegment>();
        if (children.size() > 0) {
            for (Subsegment child : children) {
                if (!child.getSubsegmentsLock().tryLock()) continue;
                try {
                    if (!this.stream(child, emitter)) continue;
                    streamable.add(child);
                }
                finally {
                    child.getSubsegmentsLock().unlock();
                }
            }
        }
        if (children.size() == streamable.size() && !entity.isInProgress()) {
            return true;
        }
        for (Subsegment child : streamable) {
            emitter.sendSubsegment(child);
            child.setEmitted(true);
            entity.removeSubsegment(child);
        }
        return false;
    }
}

