/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.plugins;

import com.amazonaws.xray.plugins.Plugin;
import com.amazonaws.xray.utils.DockerUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ECSPlugin
implements Plugin {
    private static final Log logger = LogFactory.getLog(ECSPlugin.class);
    private static final String SERVICE_NAME = "ecs";
    private static final String ECS_METADATA_KEY = "ECS_CONTAINER_METADATA_URI";
    private static final String HTTP_PREFIX = "http://";
    public static final String ORIGIN = "AWS::ECS::Container";
    private static final String CONTAINER_ID_KEY = "containerId";
    private HashMap<String, Object> runtimeContext = new HashMap();
    private DockerUtils dockerUtils = new DockerUtils();

    @Override
    public boolean isEnabled() {
        String ecsMetadataURI = System.getenv(ECS_METADATA_KEY);
        if (ecsMetadataURI == null) {
            return false;
        }
        return ecsMetadataURI.startsWith(HTTP_PREFIX);
    }

    @Override
    public String getServiceName() {
        return SERVICE_NAME;
    }

    public void populateRuntimeContext() {
        try {
            this.runtimeContext.put("container", InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException uhe) {
            logger.error("Could not get docker container ID from hostname.", uhe);
        }
        try {
            this.runtimeContext.put(CONTAINER_ID_KEY, this.dockerUtils.getContainerId());
        }
        catch (IOException e) {
            logger.error("Failed to read full container ID from container instance.", e);
        }
    }

    @Override
    public Map<String, Object> getRuntimeContext() {
        this.populateRuntimeContext();
        return this.runtimeContext;
    }

    @Override
    public String getOrigin() {
        return ORIGIN;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Plugin)) {
            return false;
        }
        return this.getOrigin().equals(((Plugin)o).getOrigin());
    }

    public int hashCode() {
        return this.getOrigin().hashCode();
    }
}

