/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.xray.model.Alias;
import com.amazonaws.services.xray.model.EdgeStatistics;
import com.amazonaws.services.xray.model.HistogramEntry;
import com.amazonaws.services.xray.model.transform.EdgeMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Edge
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer referenceId;
    private Date startTime;
    private Date endTime;
    private EdgeStatistics summaryStatistics;
    private List<HistogramEntry> responseTimeHistogram;
    private List<Alias> aliases;

    public void setReferenceId(Integer referenceId) {
        this.referenceId = referenceId;
    }

    public Integer getReferenceId() {
        return this.referenceId;
    }

    public Edge withReferenceId(Integer referenceId) {
        this.setReferenceId(referenceId);
        return this;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Edge withStartTime(Date startTime) {
        this.setStartTime(startTime);
        return this;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public Edge withEndTime(Date endTime) {
        this.setEndTime(endTime);
        return this;
    }

    public void setSummaryStatistics(EdgeStatistics summaryStatistics) {
        this.summaryStatistics = summaryStatistics;
    }

    public EdgeStatistics getSummaryStatistics() {
        return this.summaryStatistics;
    }

    public Edge withSummaryStatistics(EdgeStatistics summaryStatistics) {
        this.setSummaryStatistics(summaryStatistics);
        return this;
    }

    public List<HistogramEntry> getResponseTimeHistogram() {
        return this.responseTimeHistogram;
    }

    public void setResponseTimeHistogram(Collection<HistogramEntry> responseTimeHistogram) {
        if (responseTimeHistogram == null) {
            this.responseTimeHistogram = null;
            return;
        }
        this.responseTimeHistogram = new ArrayList<HistogramEntry>(responseTimeHistogram);
    }

    public Edge withResponseTimeHistogram(HistogramEntry ... responseTimeHistogram) {
        if (this.responseTimeHistogram == null) {
            this.setResponseTimeHistogram(new ArrayList<HistogramEntry>(responseTimeHistogram.length));
        }
        for (HistogramEntry ele : responseTimeHistogram) {
            this.responseTimeHistogram.add(ele);
        }
        return this;
    }

    public Edge withResponseTimeHistogram(Collection<HistogramEntry> responseTimeHistogram) {
        this.setResponseTimeHistogram(responseTimeHistogram);
        return this;
    }

    public List<Alias> getAliases() {
        return this.aliases;
    }

    public void setAliases(Collection<Alias> aliases) {
        if (aliases == null) {
            this.aliases = null;
            return;
        }
        this.aliases = new ArrayList<Alias>(aliases);
    }

    public Edge withAliases(Alias ... aliases) {
        if (this.aliases == null) {
            this.setAliases(new ArrayList<Alias>(aliases.length));
        }
        for (Alias ele : aliases) {
            this.aliases.add(ele);
        }
        return this;
    }

    public Edge withAliases(Collection<Alias> aliases) {
        this.setAliases(aliases);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getReferenceId() != null) {
            sb.append("ReferenceId: ").append(this.getReferenceId()).append(",");
        }
        if (this.getStartTime() != null) {
            sb.append("StartTime: ").append(this.getStartTime()).append(",");
        }
        if (this.getEndTime() != null) {
            sb.append("EndTime: ").append(this.getEndTime()).append(",");
        }
        if (this.getSummaryStatistics() != null) {
            sb.append("SummaryStatistics: ").append(this.getSummaryStatistics()).append(",");
        }
        if (this.getResponseTimeHistogram() != null) {
            sb.append("ResponseTimeHistogram: ").append(this.getResponseTimeHistogram()).append(",");
        }
        if (this.getAliases() != null) {
            sb.append("Aliases: ").append(this.getAliases());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Edge)) {
            return false;
        }
        Edge other = (Edge)obj;
        if (other.getReferenceId() == null ^ this.getReferenceId() == null) {
            return false;
        }
        if (other.getReferenceId() != null && !other.getReferenceId().equals(this.getReferenceId())) {
            return false;
        }
        if (other.getStartTime() == null ^ this.getStartTime() == null) {
            return false;
        }
        if (other.getStartTime() != null && !other.getStartTime().equals(this.getStartTime())) {
            return false;
        }
        if (other.getEndTime() == null ^ this.getEndTime() == null) {
            return false;
        }
        if (other.getEndTime() != null && !other.getEndTime().equals(this.getEndTime())) {
            return false;
        }
        if (other.getSummaryStatistics() == null ^ this.getSummaryStatistics() == null) {
            return false;
        }
        if (other.getSummaryStatistics() != null && !other.getSummaryStatistics().equals(this.getSummaryStatistics())) {
            return false;
        }
        if (other.getResponseTimeHistogram() == null ^ this.getResponseTimeHistogram() == null) {
            return false;
        }
        if (other.getResponseTimeHistogram() != null && !other.getResponseTimeHistogram().equals(this.getResponseTimeHistogram())) {
            return false;
        }
        if (other.getAliases() == null ^ this.getAliases() == null) {
            return false;
        }
        return other.getAliases() == null || other.getAliases().equals(this.getAliases());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode2 = 1;
        hashCode2 = 31 * hashCode2 + (this.getReferenceId() == null ? 0 : this.getReferenceId().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getStartTime() == null ? 0 : this.getStartTime().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getEndTime() == null ? 0 : this.getEndTime().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getSummaryStatistics() == null ? 0 : this.getSummaryStatistics().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getResponseTimeHistogram() == null ? 0 : this.getResponseTimeHistogram().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getAliases() == null ? 0 : this.getAliases().hashCode());
        return hashCode2;
    }

    public Edge clone() {
        try {
            return (Edge)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EdgeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

