/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.sqs.model.SendMessageBatchRequestEntry;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class SendMessageBatchRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String queueUrl;
    private SdkInternalList<SendMessageBatchRequestEntry> entries;

    public SendMessageBatchRequest() {
    }

    public SendMessageBatchRequest(String queueUrl) {
        this.setQueueUrl(queueUrl);
    }

    public SendMessageBatchRequest(String queueUrl, List<SendMessageBatchRequestEntry> entries) {
        this.setQueueUrl(queueUrl);
        this.setEntries(entries);
    }

    public void setQueueUrl(String queueUrl) {
        this.queueUrl = queueUrl;
    }

    public String getQueueUrl() {
        return this.queueUrl;
    }

    public SendMessageBatchRequest withQueueUrl(String queueUrl) {
        this.setQueueUrl(queueUrl);
        return this;
    }

    public List<SendMessageBatchRequestEntry> getEntries() {
        if (this.entries == null) {
            this.entries = new SdkInternalList();
        }
        return this.entries;
    }

    public void setEntries(Collection<SendMessageBatchRequestEntry> entries) {
        if (entries == null) {
            this.entries = null;
            return;
        }
        this.entries = new SdkInternalList<SendMessageBatchRequestEntry>(entries);
    }

    public SendMessageBatchRequest withEntries(SendMessageBatchRequestEntry ... entries) {
        if (this.entries == null) {
            this.setEntries(new SdkInternalList<SendMessageBatchRequestEntry>(entries.length));
        }
        for (SendMessageBatchRequestEntry ele : entries) {
            this.entries.add(ele);
        }
        return this;
    }

    public SendMessageBatchRequest withEntries(Collection<SendMessageBatchRequestEntry> entries) {
        this.setEntries(entries);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getQueueUrl() != null) {
            sb.append("QueueUrl: ").append(this.getQueueUrl()).append(",");
        }
        if (this.getEntries() != null) {
            sb.append("Entries: ").append(this.getEntries());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendMessageBatchRequest)) {
            return false;
        }
        SendMessageBatchRequest other = (SendMessageBatchRequest)obj;
        if (other.getQueueUrl() == null ^ this.getQueueUrl() == null) {
            return false;
        }
        if (other.getQueueUrl() != null && !other.getQueueUrl().equals(this.getQueueUrl())) {
            return false;
        }
        if (other.getEntries() == null ^ this.getEntries() == null) {
            return false;
        }
        return other.getEntries() == null || other.getEntries().equals(this.getEntries());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode2 = 1;
        hashCode2 = 31 * hashCode2 + (this.getQueueUrl() == null ? 0 : this.getQueueUrl().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getEntries() == null ? 0 : this.getEntries().hashCode());
        return hashCode2;
    }

    @Override
    public SendMessageBatchRequest clone() {
        return (SendMessageBatchRequest)super.clone();
    }
}

