/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.util;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.internal.SdkThreadLocalsRegistry;
import com.amazonaws.util.Base64;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

@Deprecated
@ThreadSafe
public class SignatureChecker {
    private static final ThreadLocal<Signature> SIG_CHECKER = SdkThreadLocalsRegistry.register(new ThreadLocal<Signature>(){

        @Override
        protected Signature initialValue() {
            try {
                return Signature.getInstance("SHA1withRSA");
            }
            catch (NoSuchAlgorithmException e) {
                throw new SdkClientException("Could not create RSA Signature", e);
            }
        }
    });
    private final String NOTIFICATION_TYPE = "Notification";
    private final String SUBSCRIBE_TYPE = "SubscriptionConfirmation";
    private final String UNSUBSCRIBE_TYPE = "UnsubscribeConfirmation";
    private final String TYPE = "Type";
    private final String SUBSCRIBE_URL = "SubscribeURL";
    private final String MESSAGE = "Message";
    private final String TIMESTAMP = "Timestamp";
    private final String SIGNATURE_VERSION = "SignatureVersion";
    private final String SIGNATURE = "Signature";
    private final String MESSAGE_ID = "MessageId";
    private final String SUBJECT = "Subject";
    private final String TOPIC = "TopicArn";
    private final String TOKEN = "Token";
    private final Set<String> INTERESTING_FIELDS = new HashSet<String>(Arrays.asList("Type", "SubscribeURL", "Message", "Timestamp", "Signature", "SignatureVersion", "MessageId", "Subject", "TopicArn", "Token"));

    public boolean verifyMessageSignature(String message, PublicKey publicKey) {
        Map<String, String> parsed = this.parseJSON(message);
        return this.verifySignature(parsed, publicKey);
    }

    public boolean verifySignature(Map<String, String> parsedMessage, PublicKey publicKey) {
        boolean valid = false;
        String version = parsedMessage.get("SignatureVersion");
        if (version.equals("1")) {
            String signed;
            String type2 = parsedMessage.get("Type");
            String signature2 = parsedMessage.get("Signature");
            if (type2.equals("Notification")) {
                signed = this.stringToSign(this.publishMessageValues(parsedMessage));
            } else if (type2.equals("SubscriptionConfirmation")) {
                signed = this.stringToSign(this.subscribeMessageValues(parsedMessage));
            } else if (type2.equals("UnsubscribeConfirmation")) {
                signed = this.stringToSign(this.subscribeMessageValues(parsedMessage));
            } else {
                throw new RuntimeException("Cannot process message of type " + type2);
            }
            valid = this.verifySignature(signed, signature2, publicKey);
        }
        return valid;
    }

    public boolean verifySignature(String message, String signature2, PublicKey publicKey) {
        boolean result2 = false;
        try {
            byte[] sigbytes = Base64.decode(signature2.getBytes());
            Signature sigChecker = SIG_CHECKER.get();
            sigChecker.initVerify(publicKey);
            sigChecker.update(message.getBytes());
            result2 = sigChecker.verify(sigbytes);
        }
        catch (InvalidKeyException invalidKeyException) {
        }
        catch (SignatureException signatureException) {
            // empty catch block
        }
        return result2;
    }

    protected String stringToSign(SortedMap<String, String> signables) {
        StringBuilder sb = new StringBuilder();
        for (String k : signables.keySet()) {
            sb.append(k).append("\n");
            sb.append((String)signables.get(k)).append("\n");
        }
        String result2 = sb.toString();
        return result2;
    }

    private Map<String, String> parseJSON(String jsonmessage) {
        HashMap<String, String> parsed = new HashMap<String, String>();
        JsonFactory jf = new JsonFactory();
        try {
            JsonParser parser = jf.createParser(jsonmessage);
            parser.nextToken();
            while (parser.nextToken() != JsonToken.END_OBJECT) {
                String value;
                String fieldname = parser.getCurrentName();
                if (!this.INTERESTING_FIELDS.contains(fieldname)) {
                    parser.skipChildren();
                    continue;
                }
                parser.nextToken();
                if (parser.getCurrentToken() == JsonToken.START_ARRAY) {
                    value = "";
                    boolean first = true;
                    while (parser.nextToken() != JsonToken.END_ARRAY) {
                        if (!first) {
                            value = value + ",";
                        }
                        first = false;
                        value = value + parser.getText();
                    }
                } else {
                    value = parser.getText();
                }
                parsed.put(fieldname, value);
            }
        }
        catch (JsonParseException e) {
            e.printStackTrace();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return parsed;
    }

    private TreeMap<String, String> publishMessageValues(Map<String, String> parsedMessage) {
        String[] keys2;
        TreeMap<String, String> signables = new TreeMap<String, String>();
        for (String key : keys2 = new String[]{"Message", "MessageId", "Subject", "Type", "Timestamp", "TopicArn"}) {
            if (!parsedMessage.containsKey(key)) continue;
            signables.put(key, parsedMessage.get(key));
        }
        return signables;
    }

    private TreeMap<String, String> subscribeMessageValues(Map<String, String> parsedMessage) {
        String[] keys2;
        TreeMap<String, String> signables = new TreeMap<String, String>();
        for (String key : keys2 = new String[]{"SubscribeURL", "Message", "MessageId", "Type", "Timestamp", "Token", "TopicArn"}) {
            if (!parsedMessage.containsKey(key)) continue;
            signables.put(key, parsedMessage.get(key));
        }
        return signables;
    }
}

