/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalMap;
import java.io.Serializable;
import java.util.Map;

public class SubscribeRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String topicArn;
    private String protocol;
    private String endpoint;
    private SdkInternalMap<String, String> attributes;
    private Boolean returnSubscriptionArn;

    public SubscribeRequest() {
    }

    public SubscribeRequest(String topicArn, String protocol, String endpoint) {
        this.setTopicArn(topicArn);
        this.setProtocol(protocol);
        this.setEndpoint(endpoint);
    }

    public void setTopicArn(String topicArn) {
        this.topicArn = topicArn;
    }

    public String getTopicArn() {
        return this.topicArn;
    }

    public SubscribeRequest withTopicArn(String topicArn) {
        this.setTopicArn(topicArn);
        return this;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public SubscribeRequest withProtocol(String protocol) {
        this.setProtocol(protocol);
        return this;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public SubscribeRequest withEndpoint(String endpoint) {
        this.setEndpoint(endpoint);
        return this;
    }

    public Map<String, String> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new SdkInternalMap();
        }
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes == null ? null : new SdkInternalMap<String, String>(attributes);
    }

    public SubscribeRequest withAttributes(Map<String, String> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public SubscribeRequest addAttributesEntry(String key, String value) {
        if (null == this.attributes) {
            this.attributes = new SdkInternalMap();
        }
        if (this.attributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.attributes.put(key, value);
        return this;
    }

    public SubscribeRequest clearAttributesEntries() {
        this.attributes = null;
        return this;
    }

    public void setReturnSubscriptionArn(Boolean returnSubscriptionArn) {
        this.returnSubscriptionArn = returnSubscriptionArn;
    }

    public Boolean getReturnSubscriptionArn() {
        return this.returnSubscriptionArn;
    }

    public SubscribeRequest withReturnSubscriptionArn(Boolean returnSubscriptionArn) {
        this.setReturnSubscriptionArn(returnSubscriptionArn);
        return this;
    }

    public Boolean isReturnSubscriptionArn() {
        return this.returnSubscriptionArn;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTopicArn() != null) {
            sb.append("TopicArn: ").append(this.getTopicArn()).append(",");
        }
        if (this.getProtocol() != null) {
            sb.append("Protocol: ").append(this.getProtocol()).append(",");
        }
        if (this.getEndpoint() != null) {
            sb.append("Endpoint: ").append(this.getEndpoint()).append(",");
        }
        if (this.getAttributes() != null) {
            sb.append("Attributes: ").append(this.getAttributes()).append(",");
        }
        if (this.getReturnSubscriptionArn() != null) {
            sb.append("ReturnSubscriptionArn: ").append(this.getReturnSubscriptionArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubscribeRequest)) {
            return false;
        }
        SubscribeRequest other = (SubscribeRequest)obj;
        if (other.getTopicArn() == null ^ this.getTopicArn() == null) {
            return false;
        }
        if (other.getTopicArn() != null && !other.getTopicArn().equals(this.getTopicArn())) {
            return false;
        }
        if (other.getProtocol() == null ^ this.getProtocol() == null) {
            return false;
        }
        if (other.getProtocol() != null && !other.getProtocol().equals(this.getProtocol())) {
            return false;
        }
        if (other.getEndpoint() == null ^ this.getEndpoint() == null) {
            return false;
        }
        if (other.getEndpoint() != null && !other.getEndpoint().equals(this.getEndpoint())) {
            return false;
        }
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        if (other.getAttributes() != null && !other.getAttributes().equals(this.getAttributes())) {
            return false;
        }
        if (other.getReturnSubscriptionArn() == null ^ this.getReturnSubscriptionArn() == null) {
            return false;
        }
        return other.getReturnSubscriptionArn() == null || other.getReturnSubscriptionArn().equals(this.getReturnSubscriptionArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode2 = 1;
        hashCode2 = 31 * hashCode2 + (this.getTopicArn() == null ? 0 : this.getTopicArn().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getProtocol() == null ? 0 : this.getProtocol().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getEndpoint() == null ? 0 : this.getEndpoint().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getReturnSubscriptionArn() == null ? 0 : this.getReturnSubscriptionArn().hashCode());
        return hashCode2;
    }

    @Override
    public SubscribeRequest clone() {
        return (SubscribeRequest)super.clone();
    }
}

