/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.jmespath.JmesPathEvaluationVisitor;
import com.amazonaws.jmespath.JmesPathExpression;
import com.amazonaws.jmespath.JmesPathField;
import com.amazonaws.jmespath.ObjectMapperSingleton;
import com.amazonaws.services.lambda.model.GetFunctionConfigurationResult;
import com.amazonaws.waiters.AcceptorPathMatcher;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterState;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;

@SdkInternalApi
class FunctionActive {
    FunctionActive() {
    }

    static class IsPendingMatcher
    extends WaiterAcceptor<GetFunctionConfigurationResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsPendingMatcher() {
        }

        @Override
        public boolean matches(GetFunctionConfigurationResult result2) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result2);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.path(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.RETRY;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"Pending\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathField("State");
        }
    }

    static class IsFailedMatcher
    extends WaiterAcceptor<GetFunctionConfigurationResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsFailedMatcher() {
        }

        @Override
        public boolean matches(GetFunctionConfigurationResult result2) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result2);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.path(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"Failed\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathField("State");
        }
    }

    static class IsActiveMatcher
    extends WaiterAcceptor<GetFunctionConfigurationResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsActiveMatcher() {
        }

        @Override
        public boolean matches(GetFunctionConfigurationResult result2) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result2);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.path(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.SUCCESS;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"Active\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathField("State");
        }
    }
}

