/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalMap;
import java.io.Serializable;
import java.util.Map;

public class TagResourceRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String resource;
    private SdkInternalMap<String, String> tags;

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String getResource() {
        return this.resource;
    }

    public TagResourceRequest withResource(String resource) {
        this.setResource(resource);
        return this;
    }

    public Map<String, String> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalMap();
        }
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags == null ? null : new SdkInternalMap<String, String>(tags);
    }

    public TagResourceRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public TagResourceRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new SdkInternalMap();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public TagResourceRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResource() != null) {
            sb.append("Resource: ").append(this.getResource()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagResourceRequest)) {
            return false;
        }
        TagResourceRequest other = (TagResourceRequest)obj;
        if (other.getResource() == null ^ this.getResource() == null) {
            return false;
        }
        if (other.getResource() != null && !other.getResource().equals(this.getResource())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode2 = 1;
        hashCode2 = 31 * hashCode2 + (this.getResource() == null ? 0 : this.getResource().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode2;
    }

    @Override
    public TagResourceRequest clone() {
        return (TagResourceRequest)super.clone();
    }
}

