/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.lambda.model.LayersListItem;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListLayersResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextMarker;
    private SdkInternalList<LayersListItem> layers;

    public void setNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
    }

    public String getNextMarker() {
        return this.nextMarker;
    }

    public ListLayersResult withNextMarker(String nextMarker) {
        this.setNextMarker(nextMarker);
        return this;
    }

    public List<LayersListItem> getLayers() {
        if (this.layers == null) {
            this.layers = new SdkInternalList();
        }
        return this.layers;
    }

    public void setLayers(Collection<LayersListItem> layers) {
        if (layers == null) {
            this.layers = null;
            return;
        }
        this.layers = new SdkInternalList<LayersListItem>(layers);
    }

    public ListLayersResult withLayers(LayersListItem ... layers) {
        if (this.layers == null) {
            this.setLayers(new SdkInternalList<LayersListItem>(layers.length));
        }
        for (LayersListItem ele : layers) {
            this.layers.add(ele);
        }
        return this;
    }

    public ListLayersResult withLayers(Collection<LayersListItem> layers) {
        this.setLayers(layers);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextMarker() != null) {
            sb.append("NextMarker: ").append(this.getNextMarker()).append(",");
        }
        if (this.getLayers() != null) {
            sb.append("Layers: ").append(this.getLayers());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLayersResult)) {
            return false;
        }
        ListLayersResult other = (ListLayersResult)obj;
        if (other.getNextMarker() == null ^ this.getNextMarker() == null) {
            return false;
        }
        if (other.getNextMarker() != null && !other.getNextMarker().equals(this.getNextMarker())) {
            return false;
        }
        if (other.getLayers() == null ^ this.getLayers() == null) {
            return false;
        }
        return other.getLayers() == null || other.getLayers().equals(this.getLayers());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode2 = 1;
        hashCode2 = 31 * hashCode2 + (this.getNextMarker() == null ? 0 : this.getNextMarker().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getLayers() == null ? 0 : this.getLayers().hashCode());
        return hashCode2;
    }

    public ListLayersResult clone() {
        try {
            return (ListLayersResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

