/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.services.cloudformation.model.StackResource;
import com.amazonaws.services.cloudformation.model.transform.StackResourceDriftInformationStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class StackResourceStaxUnmarshaller
implements Unmarshaller<StackResource, StaxUnmarshallerContext> {
    private static StackResourceStaxUnmarshaller instance;

    @Override
    public StackResource unmarshall(StaxUnmarshallerContext context) throws Exception {
        StackResource stackResource = new StackResource();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return stackResource;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("StackName", targetDepth)) {
                    stackResource.setStackName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("StackId", targetDepth)) {
                    stackResource.setStackId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("LogicalResourceId", targetDepth)) {
                    stackResource.setLogicalResourceId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PhysicalResourceId", targetDepth)) {
                    stackResource.setPhysicalResourceId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ResourceType", targetDepth)) {
                    stackResource.setResourceType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Timestamp", targetDepth)) {
                    stackResource.setTimestamp(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance("iso8601").unmarshall(context));
                    continue;
                }
                if (context.testExpression("ResourceStatus", targetDepth)) {
                    stackResource.setResourceStatus(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ResourceStatusReason", targetDepth)) {
                    stackResource.setResourceStatusReason(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Description", targetDepth)) {
                    stackResource.setDescription(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("DriftInformation", targetDepth)) continue;
                stackResource.setDriftInformation(StackResourceDriftInformationStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return stackResource;
    }

    public static StackResourceStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new StackResourceStaxUnmarshaller();
        }
        return instance;
    }
}

