/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudformation.model.RecordHandlerProgressRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class RecordHandlerProgressRequestMarshaller
implements Marshaller<Request<RecordHandlerProgressRequest>, RecordHandlerProgressRequest> {
    @Override
    public Request<RecordHandlerProgressRequest> marshall(RecordHandlerProgressRequest recordHandlerProgressRequest) {
        if (recordHandlerProgressRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RecordHandlerProgressRequest> request = new DefaultRequest<RecordHandlerProgressRequest>(recordHandlerProgressRequest, "AmazonCloudFormation");
        request.addParameter("Action", "RecordHandlerProgress");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (recordHandlerProgressRequest.getBearerToken() != null) {
            request.addParameter("BearerToken", StringUtils.fromString(recordHandlerProgressRequest.getBearerToken()));
        }
        if (recordHandlerProgressRequest.getOperationStatus() != null) {
            request.addParameter("OperationStatus", StringUtils.fromString(recordHandlerProgressRequest.getOperationStatus()));
        }
        if (recordHandlerProgressRequest.getCurrentOperationStatus() != null) {
            request.addParameter("CurrentOperationStatus", StringUtils.fromString(recordHandlerProgressRequest.getCurrentOperationStatus()));
        }
        if (recordHandlerProgressRequest.getStatusMessage() != null) {
            request.addParameter("StatusMessage", StringUtils.fromString(recordHandlerProgressRequest.getStatusMessage()));
        }
        if (recordHandlerProgressRequest.getErrorCode() != null) {
            request.addParameter("ErrorCode", StringUtils.fromString(recordHandlerProgressRequest.getErrorCode()));
        }
        if (recordHandlerProgressRequest.getResourceModel() != null) {
            request.addParameter("ResourceModel", StringUtils.fromString(recordHandlerProgressRequest.getResourceModel()));
        }
        if (recordHandlerProgressRequest.getClientRequestToken() != null) {
            request.addParameter("ClientRequestToken", StringUtils.fromString(recordHandlerProgressRequest.getClientRequestToken()));
        }
        return request;
    }
}

