/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudformation.model.ListTypesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListTypesRequestMarshaller
implements Marshaller<Request<ListTypesRequest>, ListTypesRequest> {
    @Override
    public Request<ListTypesRequest> marshall(ListTypesRequest listTypesRequest) {
        if (listTypesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListTypesRequest> request = new DefaultRequest<ListTypesRequest>(listTypesRequest, "AmazonCloudFormation");
        request.addParameter("Action", "ListTypes");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (listTypesRequest.getVisibility() != null) {
            request.addParameter("Visibility", StringUtils.fromString(listTypesRequest.getVisibility()));
        }
        if (listTypesRequest.getProvisioningType() != null) {
            request.addParameter("ProvisioningType", StringUtils.fromString(listTypesRequest.getProvisioningType()));
        }
        if (listTypesRequest.getDeprecatedStatus() != null) {
            request.addParameter("DeprecatedStatus", StringUtils.fromString(listTypesRequest.getDeprecatedStatus()));
        }
        if (listTypesRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(listTypesRequest.getMaxResults()));
        }
        if (listTypesRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(listTypesRequest.getNextToken()));
        }
        return request;
    }
}

