/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudformation.model.ChangeAction;
import com.amazonaws.services.cloudformation.model.Replacement;
import com.amazonaws.services.cloudformation.model.ResourceAttribute;
import com.amazonaws.services.cloudformation.model.ResourceChangeDetail;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ResourceChange
implements Serializable,
Cloneable {
    private String action;
    private String logicalResourceId;
    private String physicalResourceId;
    private String resourceType;
    private String replacement;
    private SdkInternalList<String> scope;
    private SdkInternalList<ResourceChangeDetail> details;

    public void setAction(String action) {
        this.action = action;
    }

    public String getAction() {
        return this.action;
    }

    public ResourceChange withAction(String action) {
        this.setAction(action);
        return this;
    }

    public void setAction(ChangeAction action) {
        this.withAction(action);
    }

    public ResourceChange withAction(ChangeAction action) {
        this.action = action.toString();
        return this;
    }

    public void setLogicalResourceId(String logicalResourceId) {
        this.logicalResourceId = logicalResourceId;
    }

    public String getLogicalResourceId() {
        return this.logicalResourceId;
    }

    public ResourceChange withLogicalResourceId(String logicalResourceId) {
        this.setLogicalResourceId(logicalResourceId);
        return this;
    }

    public void setPhysicalResourceId(String physicalResourceId) {
        this.physicalResourceId = physicalResourceId;
    }

    public String getPhysicalResourceId() {
        return this.physicalResourceId;
    }

    public ResourceChange withPhysicalResourceId(String physicalResourceId) {
        this.setPhysicalResourceId(physicalResourceId);
        return this;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public ResourceChange withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public void setReplacement(String replacement) {
        this.replacement = replacement;
    }

    public String getReplacement() {
        return this.replacement;
    }

    public ResourceChange withReplacement(String replacement) {
        this.setReplacement(replacement);
        return this;
    }

    public void setReplacement(Replacement replacement) {
        this.withReplacement(replacement);
    }

    public ResourceChange withReplacement(Replacement replacement) {
        this.replacement = replacement.toString();
        return this;
    }

    public List<String> getScope() {
        if (this.scope == null) {
            this.scope = new SdkInternalList();
        }
        return this.scope;
    }

    public void setScope(Collection<String> scope2) {
        if (scope2 == null) {
            this.scope = null;
            return;
        }
        this.scope = new SdkInternalList<String>(scope2);
    }

    public ResourceChange withScope(String ... scope2) {
        if (this.scope == null) {
            this.setScope(new SdkInternalList<String>(scope2.length));
        }
        for (String ele : scope2) {
            this.scope.add(ele);
        }
        return this;
    }

    public ResourceChange withScope(Collection<String> scope2) {
        this.setScope(scope2);
        return this;
    }

    public ResourceChange withScope(ResourceAttribute ... scope2) {
        SdkInternalList<String> scopeCopy = new SdkInternalList<String>(scope2.length);
        for (ResourceAttribute value : scope2) {
            scopeCopy.add(value.toString());
        }
        if (this.getScope() == null) {
            this.setScope(scopeCopy);
        } else {
            this.getScope().addAll(scopeCopy);
        }
        return this;
    }

    public List<ResourceChangeDetail> getDetails() {
        if (this.details == null) {
            this.details = new SdkInternalList();
        }
        return this.details;
    }

    public void setDetails(Collection<ResourceChangeDetail> details) {
        if (details == null) {
            this.details = null;
            return;
        }
        this.details = new SdkInternalList<ResourceChangeDetail>(details);
    }

    public ResourceChange withDetails(ResourceChangeDetail ... details) {
        if (this.details == null) {
            this.setDetails(new SdkInternalList<ResourceChangeDetail>(details.length));
        }
        for (ResourceChangeDetail ele : details) {
            this.details.add(ele);
        }
        return this;
    }

    public ResourceChange withDetails(Collection<ResourceChangeDetail> details) {
        this.setDetails(details);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAction() != null) {
            sb.append("Action: ").append(this.getAction()).append(",");
        }
        if (this.getLogicalResourceId() != null) {
            sb.append("LogicalResourceId: ").append(this.getLogicalResourceId()).append(",");
        }
        if (this.getPhysicalResourceId() != null) {
            sb.append("PhysicalResourceId: ").append(this.getPhysicalResourceId()).append(",");
        }
        if (this.getResourceType() != null) {
            sb.append("ResourceType: ").append(this.getResourceType()).append(",");
        }
        if (this.getReplacement() != null) {
            sb.append("Replacement: ").append(this.getReplacement()).append(",");
        }
        if (this.getScope() != null) {
            sb.append("Scope: ").append(this.getScope()).append(",");
        }
        if (this.getDetails() != null) {
            sb.append("Details: ").append(this.getDetails());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceChange)) {
            return false;
        }
        ResourceChange other = (ResourceChange)obj;
        if (other.getAction() == null ^ this.getAction() == null) {
            return false;
        }
        if (other.getAction() != null && !other.getAction().equals(this.getAction())) {
            return false;
        }
        if (other.getLogicalResourceId() == null ^ this.getLogicalResourceId() == null) {
            return false;
        }
        if (other.getLogicalResourceId() != null && !other.getLogicalResourceId().equals(this.getLogicalResourceId())) {
            return false;
        }
        if (other.getPhysicalResourceId() == null ^ this.getPhysicalResourceId() == null) {
            return false;
        }
        if (other.getPhysicalResourceId() != null && !other.getPhysicalResourceId().equals(this.getPhysicalResourceId())) {
            return false;
        }
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        if (other.getResourceType() != null && !other.getResourceType().equals(this.getResourceType())) {
            return false;
        }
        if (other.getReplacement() == null ^ this.getReplacement() == null) {
            return false;
        }
        if (other.getReplacement() != null && !other.getReplacement().equals(this.getReplacement())) {
            return false;
        }
        if (other.getScope() == null ^ this.getScope() == null) {
            return false;
        }
        if (other.getScope() != null && !other.getScope().equals(this.getScope())) {
            return false;
        }
        if (other.getDetails() == null ^ this.getDetails() == null) {
            return false;
        }
        return other.getDetails() == null || other.getDetails().equals(this.getDetails());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode2 = 1;
        hashCode2 = 31 * hashCode2 + (this.getAction() == null ? 0 : this.getAction().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getLogicalResourceId() == null ? 0 : this.getLogicalResourceId().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getPhysicalResourceId() == null ? 0 : this.getPhysicalResourceId().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getReplacement() == null ? 0 : this.getReplacement().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getScope() == null ? 0 : this.getScope().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getDetails() == null ? 0 : this.getDetails().hashCode());
        return hashCode2;
    }

    public ResourceChange clone() {
        try {
            return (ResourceChange)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

