/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudformation.model.AutoDeployment;
import com.amazonaws.services.cloudformation.model.Capability;
import com.amazonaws.services.cloudformation.model.Parameter;
import com.amazonaws.services.cloudformation.model.PermissionModels;
import com.amazonaws.services.cloudformation.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreateStackSetRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String stackSetName;
    private String description;
    private String templateBody;
    private String templateURL;
    private SdkInternalList<Parameter> parameters;
    private SdkInternalList<String> capabilities;
    private SdkInternalList<Tag> tags;
    private String administrationRoleARN;
    private String executionRoleName;
    private String permissionModel;
    private AutoDeployment autoDeployment;
    private String clientRequestToken;

    public void setStackSetName(String stackSetName) {
        this.stackSetName = stackSetName;
    }

    public String getStackSetName() {
        return this.stackSetName;
    }

    public CreateStackSetRequest withStackSetName(String stackSetName) {
        this.setStackSetName(stackSetName);
        return this;
    }

    public void setDescription(String description2) {
        this.description = description2;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateStackSetRequest withDescription(String description2) {
        this.setDescription(description2);
        return this;
    }

    public void setTemplateBody(String templateBody) {
        this.templateBody = templateBody;
    }

    public String getTemplateBody() {
        return this.templateBody;
    }

    public CreateStackSetRequest withTemplateBody(String templateBody) {
        this.setTemplateBody(templateBody);
        return this;
    }

    public void setTemplateURL(String templateURL) {
        this.templateURL = templateURL;
    }

    public String getTemplateURL() {
        return this.templateURL;
    }

    public CreateStackSetRequest withTemplateURL(String templateURL) {
        this.setTemplateURL(templateURL);
        return this;
    }

    public List<Parameter> getParameters() {
        if (this.parameters == null) {
            this.parameters = new SdkInternalList();
        }
        return this.parameters;
    }

    public void setParameters(Collection<Parameter> parameters2) {
        if (parameters2 == null) {
            this.parameters = null;
            return;
        }
        this.parameters = new SdkInternalList<Parameter>(parameters2);
    }

    public CreateStackSetRequest withParameters(Parameter ... parameters2) {
        if (this.parameters == null) {
            this.setParameters(new SdkInternalList<Parameter>(parameters2.length));
        }
        for (Parameter ele : parameters2) {
            this.parameters.add(ele);
        }
        return this;
    }

    public CreateStackSetRequest withParameters(Collection<Parameter> parameters2) {
        this.setParameters(parameters2);
        return this;
    }

    public List<String> getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new SdkInternalList();
        }
        return this.capabilities;
    }

    public void setCapabilities(Collection<String> capabilities) {
        if (capabilities == null) {
            this.capabilities = null;
            return;
        }
        this.capabilities = new SdkInternalList<String>(capabilities);
    }

    public CreateStackSetRequest withCapabilities(String ... capabilities) {
        if (this.capabilities == null) {
            this.setCapabilities(new SdkInternalList<String>(capabilities.length));
        }
        for (String ele : capabilities) {
            this.capabilities.add(ele);
        }
        return this;
    }

    public CreateStackSetRequest withCapabilities(Collection<String> capabilities) {
        this.setCapabilities(capabilities);
        return this;
    }

    public CreateStackSetRequest withCapabilities(Capability ... capabilities) {
        SdkInternalList<String> capabilitiesCopy = new SdkInternalList<String>(capabilities.length);
        for (Capability value : capabilities) {
            capabilitiesCopy.add(value.toString());
        }
        if (this.getCapabilities() == null) {
            this.setCapabilities(capabilitiesCopy);
        } else {
            this.getCapabilities().addAll(capabilitiesCopy);
        }
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList<Tag>(tags);
    }

    public CreateStackSetRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new SdkInternalList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateStackSetRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setAdministrationRoleARN(String administrationRoleARN) {
        this.administrationRoleARN = administrationRoleARN;
    }

    public String getAdministrationRoleARN() {
        return this.administrationRoleARN;
    }

    public CreateStackSetRequest withAdministrationRoleARN(String administrationRoleARN) {
        this.setAdministrationRoleARN(administrationRoleARN);
        return this;
    }

    public void setExecutionRoleName(String executionRoleName) {
        this.executionRoleName = executionRoleName;
    }

    public String getExecutionRoleName() {
        return this.executionRoleName;
    }

    public CreateStackSetRequest withExecutionRoleName(String executionRoleName) {
        this.setExecutionRoleName(executionRoleName);
        return this;
    }

    public void setPermissionModel(String permissionModel) {
        this.permissionModel = permissionModel;
    }

    public String getPermissionModel() {
        return this.permissionModel;
    }

    public CreateStackSetRequest withPermissionModel(String permissionModel) {
        this.setPermissionModel(permissionModel);
        return this;
    }

    public CreateStackSetRequest withPermissionModel(PermissionModels permissionModel) {
        this.permissionModel = permissionModel.toString();
        return this;
    }

    public void setAutoDeployment(AutoDeployment autoDeployment) {
        this.autoDeployment = autoDeployment;
    }

    public AutoDeployment getAutoDeployment() {
        return this.autoDeployment;
    }

    public CreateStackSetRequest withAutoDeployment(AutoDeployment autoDeployment) {
        this.setAutoDeployment(autoDeployment);
        return this;
    }

    public void setClientRequestToken(String clientRequestToken) {
        this.clientRequestToken = clientRequestToken;
    }

    public String getClientRequestToken() {
        return this.clientRequestToken;
    }

    public CreateStackSetRequest withClientRequestToken(String clientRequestToken) {
        this.setClientRequestToken(clientRequestToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStackSetName() != null) {
            sb.append("StackSetName: ").append(this.getStackSetName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getTemplateBody() != null) {
            sb.append("TemplateBody: ").append(this.getTemplateBody()).append(",");
        }
        if (this.getTemplateURL() != null) {
            sb.append("TemplateURL: ").append(this.getTemplateURL()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters()).append(",");
        }
        if (this.getCapabilities() != null) {
            sb.append("Capabilities: ").append(this.getCapabilities()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getAdministrationRoleARN() != null) {
            sb.append("AdministrationRoleARN: ").append(this.getAdministrationRoleARN()).append(",");
        }
        if (this.getExecutionRoleName() != null) {
            sb.append("ExecutionRoleName: ").append(this.getExecutionRoleName()).append(",");
        }
        if (this.getPermissionModel() != null) {
            sb.append("PermissionModel: ").append(this.getPermissionModel()).append(",");
        }
        if (this.getAutoDeployment() != null) {
            sb.append("AutoDeployment: ").append(this.getAutoDeployment()).append(",");
        }
        if (this.getClientRequestToken() != null) {
            sb.append("ClientRequestToken: ").append(this.getClientRequestToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStackSetRequest)) {
            return false;
        }
        CreateStackSetRequest other = (CreateStackSetRequest)obj;
        if (other.getStackSetName() == null ^ this.getStackSetName() == null) {
            return false;
        }
        if (other.getStackSetName() != null && !other.getStackSetName().equals(this.getStackSetName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getTemplateBody() == null ^ this.getTemplateBody() == null) {
            return false;
        }
        if (other.getTemplateBody() != null && !other.getTemplateBody().equals(this.getTemplateBody())) {
            return false;
        }
        if (other.getTemplateURL() == null ^ this.getTemplateURL() == null) {
            return false;
        }
        if (other.getTemplateURL() != null && !other.getTemplateURL().equals(this.getTemplateURL())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        if (other.getParameters() != null && !other.getParameters().equals(this.getParameters())) {
            return false;
        }
        if (other.getCapabilities() == null ^ this.getCapabilities() == null) {
            return false;
        }
        if (other.getCapabilities() != null && !other.getCapabilities().equals(this.getCapabilities())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getAdministrationRoleARN() == null ^ this.getAdministrationRoleARN() == null) {
            return false;
        }
        if (other.getAdministrationRoleARN() != null && !other.getAdministrationRoleARN().equals(this.getAdministrationRoleARN())) {
            return false;
        }
        if (other.getExecutionRoleName() == null ^ this.getExecutionRoleName() == null) {
            return false;
        }
        if (other.getExecutionRoleName() != null && !other.getExecutionRoleName().equals(this.getExecutionRoleName())) {
            return false;
        }
        if (other.getPermissionModel() == null ^ this.getPermissionModel() == null) {
            return false;
        }
        if (other.getPermissionModel() != null && !other.getPermissionModel().equals(this.getPermissionModel())) {
            return false;
        }
        if (other.getAutoDeployment() == null ^ this.getAutoDeployment() == null) {
            return false;
        }
        if (other.getAutoDeployment() != null && !other.getAutoDeployment().equals(this.getAutoDeployment())) {
            return false;
        }
        if (other.getClientRequestToken() == null ^ this.getClientRequestToken() == null) {
            return false;
        }
        return other.getClientRequestToken() == null || other.getClientRequestToken().equals(this.getClientRequestToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode2 = 1;
        hashCode2 = 31 * hashCode2 + (this.getStackSetName() == null ? 0 : this.getStackSetName().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getTemplateBody() == null ? 0 : this.getTemplateBody().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getTemplateURL() == null ? 0 : this.getTemplateURL().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getCapabilities() == null ? 0 : this.getCapabilities().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getAdministrationRoleARN() == null ? 0 : this.getAdministrationRoleARN().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getExecutionRoleName() == null ? 0 : this.getExecutionRoleName().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getPermissionModel() == null ? 0 : this.getPermissionModel().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getAutoDeployment() == null ? 0 : this.getAutoDeployment().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getClientRequestToken() == null ? 0 : this.getClientRequestToken().hashCode());
        return hashCode2;
    }

    @Override
    public CreateStackSetRequest clone() {
        return (CreateStackSetRequest)super.clone();
    }
}

