/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.strategy;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.xray.entities.Entity;
import com.amazonaws.xray.entities.Subsegment;
import com.amazonaws.xray.entities.ThrowableDescription;
import com.amazonaws.xray.strategy.ThrowableSerializationStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultThrowableSerializationStrategy
implements ThrowableSerializationStrategy {
    private static final Log logger = LogFactory.getLog(DefaultThrowableSerializationStrategy.class);
    private static final int DEFAULT_MAX_STACK_TRACE_LENGTH = 50;
    private static Set<Class<? extends Throwable>> DEFAULT_REMOTE_EXCEPTION_CLASSES = new HashSet<Class<? extends Throwable>>();
    private int maxStackTraceLength;
    private Set<Class<? extends Throwable>> remoteExceptionClasses = new HashSet<Class<? extends Throwable>>();

    public DefaultThrowableSerializationStrategy() {
        this(50);
    }

    public DefaultThrowableSerializationStrategy(int maxStackTraceLength) {
        this(maxStackTraceLength, DEFAULT_REMOTE_EXCEPTION_CLASSES);
    }

    public DefaultThrowableSerializationStrategy(int maxStackTraceLength, Set<Class<? extends Throwable>> remoteExceptionClasses) {
        this.maxStackTraceLength = maxStackTraceLength;
        this.remoteExceptionClasses = remoteExceptionClasses;
    }

    private boolean isRemote(Throwable throwable) {
        return this.remoteExceptionClasses.parallelStream().anyMatch(remoteExceptionClass -> remoteExceptionClass.isInstance(throwable));
    }

    private Optional<ThrowableDescription> referenceInChildren(Throwable throwable, List<Subsegment> subsegments) {
        return subsegments.parallelStream().flatMap(subsegment -> subsegment.getCause().getExceptions().stream()).filter(throwableDescription -> throwable.equals(throwableDescription.getThrowable())).findAny();
    }

    private ThrowableDescription describeThrowable(Throwable throwable, String id) {
        ThrowableDescription description = new ThrowableDescription();
        description.setId(id);
        description.setMessage(throwable.getMessage());
        description.setType(throwable.getClass().getName());
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        if (stackTrace.length > this.maxStackTraceLength) {
            description.setStack(Arrays.copyOfRange(stackTrace, 0, this.maxStackTraceLength));
            description.setTruncated(stackTrace.length - this.maxStackTraceLength);
        } else {
            description.setStack(stackTrace);
        }
        description.setThrowable(throwable);
        if (this.isRemote(throwable)) {
            description.setRemote(true);
        }
        return description;
    }

    @Override
    public List<ThrowableDescription> describeInContext(Throwable throwable, List<Subsegment> subsegments) {
        ArrayList<ThrowableDescription> result = new ArrayList<ThrowableDescription>();
        ThrowableDescription description = new ThrowableDescription();
        Optional<ThrowableDescription> exceptionReferenced = this.referenceInChildren(throwable, subsegments);
        if (exceptionReferenced.isPresent()) {
            description.setCause(null == exceptionReferenced.get().getId() ? exceptionReferenced.get().getCause() : exceptionReferenced.get().getId());
            description.setThrowable(throwable);
            result.add(description);
            return result;
        }
        description = this.describeThrowable(throwable, Entity.generateId());
        result.add(description);
        for (Throwable nextNode = throwable.getCause(); null != nextNode; nextNode = nextNode.getCause()) {
            Throwable currentNode = nextNode;
            exceptionReferenced = this.referenceInChildren(currentNode, subsegments);
            if (exceptionReferenced.isPresent()) {
                description.setCause(null == exceptionReferenced.get().getId() ? exceptionReferenced.get().getCause() : exceptionReferenced.get().getId());
            } else {
                String newId = Entity.generateId();
                description.setCause(newId);
                description = this.describeThrowable(currentNode, newId);
            }
            result.add(description);
        }
        return result;
    }

    public int getMaxStackTraceLength() {
        return this.maxStackTraceLength;
    }

    static {
        DEFAULT_REMOTE_EXCEPTION_CLASSES.add(AmazonServiceException.class);
    }
}

