/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.strategy;

import com.amazonaws.xray.emitters.Emitter;
import com.amazonaws.xray.entities.Entity;
import com.amazonaws.xray.entities.Segment;
import com.amazonaws.xray.entities.Subsegment;
import com.amazonaws.xray.strategy.StreamingStrategy;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultStreamingStrategy
implements StreamingStrategy {
    private static final Log logger = LogFactory.getLog(DefaultStreamingStrategy.class);
    private static final int DEFAULT_MAX_SEGMENT_SIZE = 100;
    private final int maxSegmentSize;

    public DefaultStreamingStrategy() {
        this(100);
    }

    public DefaultStreamingStrategy(int maxSegmentSize) {
        if (maxSegmentSize < 0) {
            throw new IllegalArgumentException("maxSegmentSize must be a non-negative integer.");
        }
        this.maxSegmentSize = maxSegmentSize;
    }

    @Override
    public boolean requiresStreaming(Segment segment) {
        if (segment.isSampled() && null != segment.getTotalSize()) {
            return segment.getTotalSize().intValue() > this.maxSegmentSize;
        }
        return false;
    }

    @Override
    public void streamSome(Entity entity, Emitter emitter) {
        if (entity.getSubsegmentsLock().tryLock()) {
            try {
                new ArrayList<Subsegment>(entity.getSubsegments()).forEach(subsegment -> {
                    if (subsegment.isInProgress() || !subsegment.getSubsegments().isEmpty()) {
                        this.streamSome((Entity)subsegment, emitter);
                    } else {
                        emitter.sendSubsegment((Subsegment)subsegment);
                        subsegment.setEmitted(true);
                        entity.removeSubsegment((Subsegment)subsegment);
                    }
                });
            }
            finally {
                entity.getSubsegmentsLock().unlock();
            }
        }
    }
}

