/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequestEntry;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DeleteMessageBatchRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String queueUrl;
    private SdkInternalList<DeleteMessageBatchRequestEntry> entries;

    public DeleteMessageBatchRequest() {
    }

    public DeleteMessageBatchRequest(String queueUrl) {
        this.setQueueUrl(queueUrl);
    }

    public DeleteMessageBatchRequest(String queueUrl, List<DeleteMessageBatchRequestEntry> entries) {
        this.setQueueUrl(queueUrl);
        this.setEntries(entries);
    }

    public void setQueueUrl(String queueUrl) {
        this.queueUrl = queueUrl;
    }

    public String getQueueUrl() {
        return this.queueUrl;
    }

    public DeleteMessageBatchRequest withQueueUrl(String queueUrl) {
        this.setQueueUrl(queueUrl);
        return this;
    }

    public List<DeleteMessageBatchRequestEntry> getEntries() {
        if (this.entries == null) {
            this.entries = new SdkInternalList();
        }
        return this.entries;
    }

    public void setEntries(Collection<DeleteMessageBatchRequestEntry> entries) {
        if (entries == null) {
            this.entries = null;
            return;
        }
        this.entries = new SdkInternalList<DeleteMessageBatchRequestEntry>(entries);
    }

    public DeleteMessageBatchRequest withEntries(DeleteMessageBatchRequestEntry ... entries) {
        if (this.entries == null) {
            this.setEntries(new SdkInternalList<DeleteMessageBatchRequestEntry>(entries.length));
        }
        for (DeleteMessageBatchRequestEntry ele : entries) {
            this.entries.add(ele);
        }
        return this;
    }

    public DeleteMessageBatchRequest withEntries(Collection<DeleteMessageBatchRequestEntry> entries) {
        this.setEntries(entries);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getQueueUrl() != null) {
            sb.append("QueueUrl: ").append(this.getQueueUrl()).append(",");
        }
        if (this.getEntries() != null) {
            sb.append("Entries: ").append(this.getEntries());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteMessageBatchRequest)) {
            return false;
        }
        DeleteMessageBatchRequest other = (DeleteMessageBatchRequest)obj;
        if (other.getQueueUrl() == null ^ this.getQueueUrl() == null) {
            return false;
        }
        if (other.getQueueUrl() != null && !other.getQueueUrl().equals(this.getQueueUrl())) {
            return false;
        }
        if (other.getEntries() == null ^ this.getEntries() == null) {
            return false;
        }
        return other.getEntries() == null || other.getEntries().equals(this.getEntries());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getQueueUrl() == null ? 0 : this.getQueueUrl().hashCode());
        hashCode = 31 * hashCode + (this.getEntries() == null ? 0 : this.getEntries().hashCode());
        return hashCode;
    }

    @Override
    public DeleteMessageBatchRequest clone() {
        return (DeleteMessageBatchRequest)super.clone();
    }
}

