/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.emitters;

import com.amazonaws.xray.config.DaemonConfiguration;
import com.amazonaws.xray.emitters.Emitter;
import com.amazonaws.xray.entities.Segment;
import com.amazonaws.xray.entities.Subsegment;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UDPEmitter
extends Emitter {
    private static final Log logger = LogFactory.getLog(UDPEmitter.class);
    private DatagramSocket daemonSocket;
    private DaemonConfiguration config;
    private byte[] sendBuffer = new byte[262144];

    public UDPEmitter() throws SocketException {
        this.config = new DaemonConfiguration();
        try {
            this.daemonSocket = new DatagramSocket();
        }
        catch (SocketException e) {
            logger.error("Exception while instantiating daemon socket.", e);
            throw e;
        }
    }

    @Override
    public boolean sendSegment(Segment segment) {
        if (logger.isDebugEnabled()) {
            logger.debug(segment.prettySerialize());
        }
        return this.sendData(("{\"format\": \"json\", \"version\": 1}\n" + segment.serialize()).getBytes());
    }

    @Override
    public boolean sendSubsegment(Subsegment subsegment) {
        if (logger.isDebugEnabled()) {
            logger.debug(subsegment.prettyStreamSerialize());
        }
        return this.sendData(("{\"format\": \"json\", \"version\": 1}\n" + subsegment.streamSerialize()).getBytes());
    }

    private boolean sendData(byte[] data) {
        DatagramPacket packet = new DatagramPacket(this.sendBuffer, 262144, this.config.getAddressForEmitter());
        packet.setData(data);
        try {
            logger.debug("Sending UDP packet.");
            this.daemonSocket.send(packet);
        }
        catch (IOException e) {
            logger.error("Exception while sending segment over UDP.", e);
            return false;
        }
        return true;
    }
}

