/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.services.lambda.model.FunctionCode;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;
import java.nio.ByteBuffer;

public class FunctionCodeJsonUnmarshaller
implements Unmarshaller<FunctionCode, JsonUnmarshallerContext> {
    private static FunctionCodeJsonUnmarshaller instance;

    @Override
    public FunctionCode unmarshall(JsonUnmarshallerContext context) throws Exception {
        FunctionCode functionCode = new FunctionCode();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("ZipFile", targetDepth)) {
                    context.nextToken();
                    functionCode.setZipFile(context.getUnmarshaller(ByteBuffer.class).unmarshall(context));
                }
                if (context.testExpression("S3Bucket", targetDepth)) {
                    context.nextToken();
                    functionCode.setS3Bucket(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("S3Key", targetDepth)) {
                    context.nextToken();
                    functionCode.setS3Key(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("S3ObjectVersion", targetDepth)) {
                    context.nextToken();
                    functionCode.setS3ObjectVersion(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return functionCode;
    }

    public static FunctionCodeJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new FunctionCodeJsonUnmarshaller();
        }
        return instance;
    }
}

