/*
 * Decompiled with CFR 0.152.
 */
package pl.wrzasq.lambda.edgedeploy.service;

import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.model.CreateFunctionRequest;
import com.amazonaws.services.lambda.model.CreateFunctionResult;
import com.amazonaws.services.lambda.model.DeleteFunctionRequest;
import com.amazonaws.services.lambda.model.FunctionCode;
import com.amazonaws.services.lambda.model.PublishVersionRequest;
import com.amazonaws.services.lambda.model.PublishVersionResult;
import com.amazonaws.services.lambda.model.ResourceNotFoundException;
import com.amazonaws.services.lambda.model.TracingConfig;
import com.amazonaws.services.lambda.model.UpdateFunctionCodeRequest;
import com.amazonaws.services.lambda.model.UpdateFunctionConfigurationRequest;
import com.amazonaws.services.s3.AmazonS3;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.wrzasq.commons.aws.cloudformation.CustomResourceResponse;
import pl.wrzasq.lambda.edgedeploy.model.EdgeDeployRequest;
import pl.wrzasq.lambda.edgedeploy.zip.ZipBuilder;

public class LambdaEdgeManager {
    private Logger logger = LoggerFactory.getLogger(LambdaEdgeManager.class);
    private AWSLambda lambda;
    private AmazonS3 s3;
    private ObjectMapper objectMapper;

    public LambdaEdgeManager(AWSLambda lambda, AmazonS3 s3, ObjectMapper objectMapper) {
        this.lambda = lambda;
        this.s3 = s3;
        this.objectMapper = objectMapper;
    }

    public CustomResourceResponse<PublishVersionResult> create(EdgeDeployRequest input, String physicalResourceId) {
        CreateFunctionResult result = this.lambda.createFunction(new CreateFunctionRequest().withFunctionName(input.getFunctionName()).withDescription(input.getFunctionDescription()).withRuntime(input.getRuntime()).withCode(new FunctionCode().withZipFile(this.buildZipFile(input))).withHandler(input.getHandler()).withMemorySize(input.getMemory()).withTimeout(input.getTimeout()).withRole(input.getRoleArn()).withTracingConfig(new TracingConfig().withMode(input.getTracingMode())));
        return new CustomResourceResponse<PublishVersionResult>(this.publishLambdaVersion(input.getFunctionName()), result.getFunctionArn());
    }

    public CustomResourceResponse<PublishVersionResult> update(EdgeDeployRequest input, String physicalResourceId) {
        this.lambda.updateFunctionCode(new UpdateFunctionCodeRequest().withFunctionName(input.getFunctionName()).withZipFile(this.buildZipFile(input)));
        this.lambda.updateFunctionConfiguration(new UpdateFunctionConfigurationRequest().withFunctionName(input.getFunctionName()).withDescription(input.getFunctionDescription()).withRuntime(input.getRuntime()).withHandler(input.getHandler()).withMemorySize(input.getMemory()).withTimeout(input.getTimeout()).withRole(input.getRoleArn()).withTracingConfig(new TracingConfig().withMode(input.getTracingMode())));
        return new CustomResourceResponse<PublishVersionResult>(this.publishLambdaVersion(input.getFunctionName()), physicalResourceId);
    }

    public CustomResourceResponse<PublishVersionResult> delete(EdgeDeployRequest input, String physicalResourceId) {
        try {
            this.lambda.deleteFunction(new DeleteFunctionRequest().withFunctionName(input.getFunctionName()));
        }
        catch (ResourceNotFoundException error) {
            this.logger.warn("Attempt to delete non-existing Lambda {}.", (Object)input.getFunctionName(), (Object)error);
        }
        return new CustomResourceResponse<PublishVersionResult>(new PublishVersionResult().withFunctionName(input.getFunctionName()), physicalResourceId);
    }

    private PublishVersionResult publishLambdaVersion(String functionName) {
        return this.lambda.publishVersion(new PublishVersionRequest().withFunctionName(functionName));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ByteBuffer buildZipFile(EdgeDeployRequest input) {
        ZipBuilder zip = new ZipBuilder();
        try (ZipInputStream archive = new ZipInputStream(this.s3.getObject(input.getPackageBucket(), input.getPackageKey()).getObjectContent());){
            zip.copyFrom(archive);
            zip.writeEntry(input.getConfigFile(), this.objectMapper.writeValueAsBytes(input.getConfig()));
            ByteBuffer byteBuffer = zip.dump();
            return byteBuffer;
        }
        catch (IOException error) {
            throw new RuntimeException(error);
        }
    }
}

