/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.strategy.sampling.rule;

import com.amazonaws.services.xray.model.SamplingRule;
import com.amazonaws.services.xray.model.SamplingStatisticsDocument;
import com.amazonaws.services.xray.model.SamplingTargetDocument;
import com.amazonaws.xray.strategy.sampling.SamplingRequest;
import com.amazonaws.xray.strategy.sampling.SamplingResponse;
import com.amazonaws.xray.strategy.sampling.rand.Rand;
import com.amazonaws.xray.strategy.sampling.reservoir.CentralizedReservoir;
import com.amazonaws.xray.strategy.sampling.rule.Matchers;
import com.amazonaws.xray.strategy.sampling.rule.Rule;
import com.amazonaws.xray.strategy.sampling.rule.Statistics;
import java.time.Instant;
import java.util.Date;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CentralizedRule
implements Rule,
Comparable<CentralizedRule> {
    private static final Log logger = LogFactory.getLog(CentralizedRule.class);
    public static final String DEFAULT_RULE_NAME = "Default";
    private int priority = 10000;
    private String name;
    private CentralizedReservoir centralizedReservoir;
    private double fixedRate;
    private Statistics statistics;
    private Matchers matchers;
    private Rand rand;
    private ReadWriteLock lock;

    public CentralizedRule(SamplingRule input, Rand rand) {
        this.name = input.getRuleName();
        this.centralizedReservoir = new CentralizedReservoir(input.getReservoirSize().intValue());
        this.fixedRate = input.getFixedRate();
        this.statistics = new Statistics();
        if (!input.getRuleName().equals(DEFAULT_RULE_NAME)) {
            this.matchers = new Matchers(input);
            this.priority = input.getPriority();
        }
        this.rand = rand;
        this.lock = new ReentrantReadWriteLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(SamplingRule i) {
        boolean rebuild = false;
        Matchers m = new Matchers(i);
        this.lock.writeLock().lock();
        try {
            this.fixedRate = i.getFixedRate();
            if (this.priority != i.getPriority()) {
                rebuild = true;
            }
            this.priority = i.getPriority();
            this.fixedRate = i.getFixedRate();
            this.matchers = m;
            this.centralizedReservoir.update(i);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return rebuild;
    }

    public boolean isStale(Instant now) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.statistics.getRequests() > 0 && this.centralizedReservoir.isStale(now);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public static boolean isValid(SamplingRule rule) {
        if (rule.getRuleName() == null || rule.getPriority() == null || rule.getReservoirSize() == null || rule.getFixedRate() == null || rule.getVersion() != 1) {
            logger.error("Detect invalid rule. Please check sampling rule format.");
            return false;
        }
        if (!rule.getResourceARN().equals("*") || !rule.getAttributes().isEmpty()) {
            logger.error("Detect invalid rule. Please check sampling rule format.");
            return false;
        }
        if (rule.getHost() == null || rule.getServiceName() == null || rule.getHTTPMethod() == null || rule.getURLPath() == null || rule.getServiceType() == null) {
            logger.error("Detect invalid rule. Please check sampling rule format.");
            return false;
        }
        if (rule.getRuleName().equals(DEFAULT_RULE_NAME)) {
            return true;
        }
        return true;
    }

    public void update(SamplingTargetDocument t, Instant now) {
        this.lock.writeLock().lock();
        try {
            this.centralizedReservoir.update(t, now);
            this.fixedRate = t.getFixedRate();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public SamplingStatisticsDocument snapshot(Date now) {
        SamplingStatisticsDocument s = new SamplingStatisticsDocument().withRuleName(this.name).withTimestamp(now);
        this.lock.writeLock().lock();
        try {
            s.setRequestCount(this.statistics.getRequests());
            s.setSampledCount(this.statistics.getSampled());
            s.setBorrowCount(this.statistics.getBorrowed());
            this.statistics.reset();
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return s;
    }

    public boolean match(SamplingRequest r) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.matchers != null ? this.matchers.match(r) : true;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SamplingResponse sample(Instant now) {
        SamplingResponse res = new SamplingResponse(this.name);
        double rn = this.rand.next();
        this.lock.writeLock().lock();
        try {
            SamplingResponse samplingResponse = this.doSample(now, res, rn);
            return samplingResponse;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private SamplingResponse doSample(Instant now, SamplingResponse res, double random) {
        this.statistics.incRequest();
        return this.doSampleCustomerRule(now, res, random);
    }

    private SamplingResponse doSampleCustomerRule(Instant now, SamplingResponse res, double random) {
        if (this.centralizedReservoir.isExpired(now)) {
            if (this.centralizedReservoir.isBorrow(now)) {
                logger.debug("Sampling target has expired for rule " + this.getName() + ". Burrowing a request.");
                this.statistics.incBorrowed();
                res.setSampled(true);
                return res;
            }
            logger.debug("Sampling target has expired for rule " + this.getName() + ". Using fixed rate.");
            if (random < this.fixedRate) {
                this.statistics.incSampled();
                res.setSampled(true);
                return res;
            }
            return res;
        }
        if (this.centralizedReservoir.take(now)) {
            this.statistics.incSampled();
            res.setSampled(true);
            logger.debug("Sampling target has been exhausted for rule " + this.getName() + ". Using fixed request.");
            return res;
        }
        if (random < this.fixedRate) {
            this.statistics.incSampled();
            res.setSampled(true);
            return res;
        }
        return res;
    }

    @Override
    public int compareTo(CentralizedRule other) {
        this.lock.readLock().lock();
        try {
            if (this.priority < other.priority) {
                int n = -1;
                return n;
            }
            if (this.priority > other.priority) {
                int n = 1;
                return n;
            }
            int n = this.getName().compareTo(other.getName());
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CentralizedRule that = (CentralizedRule)o;
        if (this.priority != that.priority) {
            return false;
        }
        if (Double.compare(that.fixedRate, this.fixedRate) != 0) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.centralizedReservoir.equals(that.centralizedReservoir)) {
            return false;
        }
        if (!this.statistics.equals(that.statistics)) {
            return false;
        }
        return this.matchers != null ? this.matchers.equals(that.matchers) : that.matchers == null;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.priority;
        result = 31 * result + this.centralizedReservoir.hashCode();
        long temp = Double.doubleToLongBits(this.fixedRate);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.statistics.hashCode();
        result = 31 * result + (this.matchers != null ? this.matchers.hashCode() : 0);
        return result;
    }
}

