/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.strategy.sampling.manifest;

import com.amazonaws.services.xray.model.SamplingRule;
import com.amazonaws.services.xray.model.SamplingStatisticsDocument;
import com.amazonaws.services.xray.model.SamplingTargetDocument;
import com.amazonaws.xray.strategy.sampling.CentralizedSamplingStrategy;
import com.amazonaws.xray.strategy.sampling.SamplingRequest;
import com.amazonaws.xray.strategy.sampling.manifest.Manifest;
import com.amazonaws.xray.strategy.sampling.rand.RandImpl;
import com.amazonaws.xray.strategy.sampling.rule.CentralizedRule;
import com.amazonaws.xray.strategy.sampling.rule.Rule;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CentralizedManifest
implements Manifest {
    private static final Log logger = LogFactory.getLog(CentralizedManifest.class);
    private static final long TTL = 3600L;
    private volatile LinkedHashMap<String, CentralizedRule> rules = new LinkedHashMap(0);
    private volatile CentralizedRule defaultRule;
    private volatile Instant refreshedAt = Instant.EPOCH;

    public LinkedHashMap<String, CentralizedRule> getRules() {
        return this.rules;
    }

    public CentralizedRule getDefaultRule() {
        return this.defaultRule;
    }

    public boolean isExpired(Instant now) {
        return this.refreshedAt.plusSeconds(3600L).isBefore(now);
    }

    public int size() {
        if (this.defaultRule != null) {
            return this.rules.size() + 1;
        }
        return this.rules.size();
    }

    @Override
    public Rule match(SamplingRequest req, Instant now) {
        for (CentralizedRule r : this.rules.values()) {
            if (!r.match(req)) continue;
            return r;
        }
        CentralizedRule r = this.defaultRule;
        if (r != null) {
            return r;
        }
        return null;
    }

    public void putRules(List<SamplingRule> inputs, Instant now) {
        boolean invalidate = false;
        LinkedHashMap<String, CentralizedRule> rules = this.rules;
        for (SamplingRule i : inputs) {
            if (i.getRuleName().equals("Default")) {
                this.putDefaultRule(i);
                continue;
            }
            invalidate = this.putCustomRule(rules, i);
        }
        if (invalidate) {
            this.rules = this.rebuild(rules, inputs);
        }
        this.refreshedAt = now;
    }

    public List<SamplingStatisticsDocument> snapshots(Instant now) {
        ArrayList<SamplingStatisticsDocument> snapshots = new ArrayList<SamplingStatisticsDocument>(this.rules.size() + 1);
        Date date = Date.from(now);
        for (CentralizedRule rule : this.rules.values()) {
            if (!rule.isStale(now)) continue;
            SamplingStatisticsDocument snapshot = rule.snapshot(date);
            snapshot.withClientID(CentralizedSamplingStrategy.getClientID());
            snapshots.add(snapshot);
        }
        if (this.defaultRule != null && this.defaultRule.isStale(now)) {
            SamplingStatisticsDocument snapshot = this.defaultRule.snapshot(date);
            snapshot.withClientID(CentralizedSamplingStrategy.getClientID());
            snapshots.add(snapshot);
        }
        return snapshots;
    }

    public void putTargets(List<SamplingTargetDocument> targets, Instant now) {
        LinkedHashMap<String, CentralizedRule> rules = this.rules;
        for (SamplingTargetDocument t : targets) {
            CentralizedRule r = null;
            if (rules.containsKey(t.getRuleName())) {
                r = (CentralizedRule)rules.get(t.getRuleName());
            } else if (t.getRuleName().equals("Default")) {
                r = this.defaultRule;
            }
            if (r == null) continue;
            r.update(t, now);
        }
    }

    private boolean putCustomRule(Map<String, CentralizedRule> rules, SamplingRule i) {
        CentralizedRule r = rules.get(i.getRuleName());
        if (r == null) {
            return true;
        }
        return r.update(i);
    }

    private void putDefaultRule(SamplingRule i) {
        if (this.defaultRule == null) {
            this.defaultRule = new CentralizedRule(i, new RandImpl());
        } else {
            this.defaultRule.update(i);
        }
    }

    LinkedHashMap<String, CentralizedRule> rebuild(Map<String, CentralizedRule> old, List<SamplingRule> inputs) {
        ArrayList<CentralizedRule> rules = new ArrayList<CentralizedRule>(inputs.size() - 1);
        for (SamplingRule i : inputs) {
            if (i.getRuleName().equals("Default")) continue;
            CentralizedRule r = old.containsKey(i.getRuleName()) ? old.get(i.getRuleName()) : new CentralizedRule(i, new RandImpl());
            rules.add(r);
        }
        Collections.sort(rules);
        LinkedHashMap<String, CentralizedRule> current = new LinkedHashMap<String, CentralizedRule>(rules.size());
        for (CentralizedRule r : rules) {
            current.put(r.getName(), r);
        }
        return current;
    }
}

