/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.message;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.http.apache.utils.ApacheUtils;
import com.amazonaws.services.sns.message.SnsMessage;
import com.amazonaws.services.sns.message.SnsMessageHandler;
import com.amazonaws.services.sns.message.Utils;
import com.amazonaws.util.IOUtils;
import java.net.URL;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;

public final class SnsNotification
extends SnsMessage {
    private final HttpClient httpClient;
    private final String subject;
    private final String message;
    private final URL unsubscribeUrl;

    private SnsNotification(Builder builder) {
        super(builder);
        this.httpClient = builder.httpClient;
        this.subject = builder.subject;
        this.message = builder.message;
        this.unsubscribeUrl = Utils.createUrl(builder.unsubscribeUrl);
    }

    public String getSubject() {
        return this.subject;
    }

    public String getMessage() {
        return this.message;
    }

    public URL getUnsubscribeUrl() {
        return this.unsubscribeUrl;
    }

    @Override
    public void handle(SnsMessageHandler handler) {
        handler.handle(this);
    }

    public void unsubscribeFromTopic() {
        try {
            HttpGet request = new HttpGet(this.unsubscribeUrl.toURI());
            HttpResponse response = this.httpClient.execute(request);
            if (!ApacheUtils.isRequestSuccessful(response)) {
                throw new SdkClientException(String.format("Could not unsubscribe from %s: %d %s.%n%s", this.getTopicArn(), response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), IOUtils.toString(response.getEntity().getContent())));
            }
        }
        catch (Exception e) {
            throw new SdkClientException(e);
        }
    }

    @SdkInternalApi
    static Builder builder(HttpClient httpClient) {
        return new Builder(httpClient);
    }

    @SdkInternalApi
    static final class Builder
    extends SnsMessage.Builder<Builder> {
        private final HttpClient httpClient;
        private String subject;
        private String message;
        private String unsubscribeUrl;

        private Builder(HttpClient httpClient) {
            this.httpClient = httpClient;
        }

        public Builder withSubject(String subject) {
            this.subject = subject;
            return this;
        }

        public Builder withMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder withUnsubscribeUrl(String unsubscribeUrl) {
            this.unsubscribeUrl = unsubscribeUrl;
            return this;
        }

        @Override
        public SnsNotification build() {
            return new SnsNotification(this);
        }
    }
}

