/*
 * Decompiled with CFR 0.152.
 */
package pl.wrzasq.commons.aws.cloudformation;

import com.amazonaws.services.lambda.runtime.Context;
import com.sunrun.cfnresponse.CfnRequest;
import com.sunrun.cfnresponse.CfnResponseSender;
import com.sunrun.cfnresponse.Status;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.wrzasq.commons.aws.cloudformation.CustomResourceResponse;

public class CustomResourceHandler<InputType, OutputType> {
    private Logger logger = LoggerFactory.getLogger(CustomResourceHandler.class);
    private CfnResponseSender sender = new CfnResponseSender();
    private Map<String, BiFunction<InputType, String, CustomResourceResponse<OutputType>>> actions = new HashMap<String, BiFunction<InputType, String, CustomResourceResponse<OutputType>>>();

    public CustomResourceHandler(BiFunction<InputType, String, CustomResourceResponse<OutputType>> createAction, BiFunction<InputType, String, CustomResourceResponse<OutputType>> updateAction, BiFunction<InputType, String, CustomResourceResponse<OutputType>> deleteAction) {
        this.actions.put("Create", createAction);
        this.actions.put("Update", updateAction);
        this.actions.put("Delete", deleteAction);
    }

    public void handle(CfnRequest<InputType> request, Context context) {
        this.logger.info("Incoming CloudFormation request {}: {} -> {} {} ({}) (response URL: {}).", request.getRequestId(), request.getStackId(), request.getRequestType(), request.getLogicalResourceId(), request.getPhysicalResourceId(), request.getResponseURL());
        try {
            CustomResourceResponse<OutputType> response = this.actions.get(request.getRequestType()).apply(request.getResourceProperties(), request.getPhysicalResourceId());
            this.sender.send(request, Status.SUCCESS, context, "OK", response.getData(), response.getPhysicalResourceId());
        }
        catch (Exception error) {
            this.logger.error("Failed to handle resource action.", error);
            this.sender.send(request, Status.FAILED, context, error.getMessage(), null, request.getPhysicalResourceId());
        }
    }
}

